/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateListRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<UpdateListRequest.Builder, UpdateListRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateListRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> ELEMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("elements")
            .getter(getter(UpdateListRequest::elements))
            .setter(setter(Builder::elements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateListRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> UPDATE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateMode").getter(getter(UpdateListRequest::updateModeAsString)).setter(setter(Builder::updateMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateMode").build()).build();

    private static final SdkField<String> VARIABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variableType").getter(getter(UpdateListRequest::variableType)).setter(setter(Builder::variableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ELEMENTS_FIELD,
            DESCRIPTION_FIELD, UPDATE_MODE_FIELD, VARIABLE_TYPE_FIELD));

    private final String name;

    private final List<String> elements;

    private final String description;

    private final String updateMode;

    private final String variableType;

    private UpdateListRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.elements = builder.elements;
        this.description = builder.description;
        this.updateMode = builder.updateMode;
        this.variableType = builder.variableType;
    }

    /**
     * <p>
     * The name of the list to update.
     * </p>
     * 
     * @return The name of the list to update.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Elements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasElements() {
        return elements != null && !(elements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more list elements to add or replace. If you are providing the elements, make sure to specify the
     * <code>updateMode</code> to use.
     * </p>
     * <p>
     * If you are deleting all elements from the list, use <code>REPLACE</code> for the <code>updateMode</code> and
     * provide an empty list (0 elements).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElements} method.
     * </p>
     * 
     * @return One or more list elements to add or replace. If you are providing the elements, make sure to specify the
     *         <code>updateMode</code> to use. </p>
     *         <p>
     *         If you are deleting all elements from the list, use <code>REPLACE</code> for the <code>updateMode</code>
     *         and provide an empty list (0 elements).
     */
    public final List<String> elements() {
        return elements;
    }

    /**
     * <p>
     * The new description.
     * </p>
     * 
     * @return The new description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The update mode (type).
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>APPEND</code> if you are adding elements to the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>REPLACE</code> if you replacing existing elements in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>REMOVE</code> if you are removing elements from the list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateMode} will
     * return {@link ListUpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateModeAsString}.
     * </p>
     * 
     * @return The update mode (type). </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>APPEND</code> if you are adding elements to the list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>REPLACE</code> if you replacing existing elements in the list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>REMOVE</code> if you are removing elements from the list.
     *         </p>
     *         </li>
     * @see ListUpdateMode
     */
    public final ListUpdateMode updateMode() {
        return ListUpdateMode.fromValue(updateMode);
    }

    /**
     * <p>
     * The update mode (type).
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>APPEND</code> if you are adding elements to the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>REPLACE</code> if you replacing existing elements in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>REMOVE</code> if you are removing elements from the list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateMode} will
     * return {@link ListUpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateModeAsString}.
     * </p>
     * 
     * @return The update mode (type). </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>APPEND</code> if you are adding elements to the list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>REPLACE</code> if you replacing existing elements in the list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>REMOVE</code> if you are removing elements from the list.
     *         </p>
     *         </li>
     * @see ListUpdateMode
     */
    public final String updateModeAsString() {
        return updateMode;
    }

    /**
     * <p>
     * The variable type you want to assign to the list.
     * </p>
     * <note>
     * <p>
     * You cannot update a variable type of a list that already has a variable type assigned to it. You can assign a
     * variable type to a list only if the list does not already have a variable type.
     * </p>
     * </note>
     * 
     * @return The variable type you want to assign to the list. </p> <note>
     *         <p>
     *         You cannot update a variable type of a list that already has a variable type assigned to it. You can
     *         assign a variable type to a list only if the list does not already have a variable type.
     *         </p>
     */
    public final String variableType() {
        return variableType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasElements() ? elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(updateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(variableType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateListRequest)) {
            return false;
        }
        UpdateListRequest other = (UpdateListRequest) obj;
        return Objects.equals(name(), other.name()) && hasElements() == other.hasElements()
                && Objects.equals(elements(), other.elements()) && Objects.equals(description(), other.description())
                && Objects.equals(updateModeAsString(), other.updateModeAsString())
                && Objects.equals(variableType(), other.variableType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateListRequest").add("Name", name())
                .add("Elements", elements() == null ? null : "*** Sensitive Data Redacted ***").add("Description", description())
                .add("UpdateMode", updateModeAsString()).add("VariableType", variableType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "elements":
            return Optional.ofNullable(clazz.cast(elements()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "updateMode":
            return Optional.ofNullable(clazz.cast(updateModeAsString()));
        case "variableType":
            return Optional.ofNullable(clazz.cast(variableType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateListRequest, T> g) {
        return obj -> g.apply((UpdateListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateListRequest> {
        /**
         * <p>
         * The name of the list to update.
         * </p>
         * 
         * @param name
         *        The name of the list to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * One or more list elements to add or replace. If you are providing the elements, make sure to specify the
         * <code>updateMode</code> to use.
         * </p>
         * <p>
         * If you are deleting all elements from the list, use <code>REPLACE</code> for the <code>updateMode</code> and
         * provide an empty list (0 elements).
         * </p>
         * 
         * @param elements
         *        One or more list elements to add or replace. If you are providing the elements, make sure to specify
         *        the <code>updateMode</code> to use. </p>
         *        <p>
         *        If you are deleting all elements from the list, use <code>REPLACE</code> for the
         *        <code>updateMode</code> and provide an empty list (0 elements).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(Collection<String> elements);

        /**
         * <p>
         * One or more list elements to add or replace. If you are providing the elements, make sure to specify the
         * <code>updateMode</code> to use.
         * </p>
         * <p>
         * If you are deleting all elements from the list, use <code>REPLACE</code> for the <code>updateMode</code> and
         * provide an empty list (0 elements).
         * </p>
         * 
         * @param elements
         *        One or more list elements to add or replace. If you are providing the elements, make sure to specify
         *        the <code>updateMode</code> to use. </p>
         *        <p>
         *        If you are deleting all elements from the list, use <code>REPLACE</code> for the
         *        <code>updateMode</code> and provide an empty list (0 elements).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(String... elements);

        /**
         * <p>
         * The new description.
         * </p>
         * 
         * @param description
         *        The new description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The update mode (type).
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>APPEND</code> if you are adding elements to the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>REPLACE</code> if you replacing existing elements in the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>REMOVE</code> if you are removing elements from the list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateMode
         *        The update mode (type). </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>APPEND</code> if you are adding elements to the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>REPLACE</code> if you replacing existing elements in the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>REMOVE</code> if you are removing elements from the list.
         *        </p>
         *        </li>
         * @see ListUpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListUpdateMode
         */
        Builder updateMode(String updateMode);

        /**
         * <p>
         * The update mode (type).
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>APPEND</code> if you are adding elements to the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>REPLACE</code> if you replacing existing elements in the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>REMOVE</code> if you are removing elements from the list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateMode
         *        The update mode (type). </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>APPEND</code> if you are adding elements to the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>REPLACE</code> if you replacing existing elements in the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>REMOVE</code> if you are removing elements from the list.
         *        </p>
         *        </li>
         * @see ListUpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListUpdateMode
         */
        Builder updateMode(ListUpdateMode updateMode);

        /**
         * <p>
         * The variable type you want to assign to the list.
         * </p>
         * <note>
         * <p>
         * You cannot update a variable type of a list that already has a variable type assigned to it. You can assign a
         * variable type to a list only if the list does not already have a variable type.
         * </p>
         * </note>
         * 
         * @param variableType
         *        The variable type you want to assign to the list. </p> <note>
         *        <p>
         *        You cannot update a variable type of a list that already has a variable type assigned to it. You can
         *        assign a variable type to a list only if the list does not already have a variable type.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableType(String variableType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String name;

        private List<String> elements = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String updateMode;

        private String variableType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateListRequest model) {
            super(model);
            name(model.name);
            elements(model.elements);
            description(model.description);
            updateMode(model.updateMode);
            variableType(model.variableType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getElements() {
            if (elements instanceof SdkAutoConstructList) {
                return null;
            }
            return elements;
        }

        public final void setElements(Collection<String> elements) {
            this.elements = ElementsListCopier.copy(elements);
        }

        @Override
        public final Builder elements(Collection<String> elements) {
            this.elements = ElementsListCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(String... elements) {
            elements(Arrays.asList(elements));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUpdateMode() {
            return updateMode;
        }

        public final void setUpdateMode(String updateMode) {
            this.updateMode = updateMode;
        }

        @Override
        public final Builder updateMode(String updateMode) {
            this.updateMode = updateMode;
            return this;
        }

        @Override
        public final Builder updateMode(ListUpdateMode updateMode) {
            this.updateMode(updateMode == null ? null : updateMode.toString());
            return this;
        }

        public final String getVariableType() {
            return variableType;
        }

        public final void setVariableType(String variableType) {
            this.variableType = variableType;
        }

        @Override
        public final Builder variableType(String variableType) {
            this.variableType = variableType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateListRequest build() {
            return new UpdateListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
