/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventPredictionMetadataResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetEventPredictionMetadataResponse.Builder, GetEventPredictionMetadataResponse> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(GetEventPredictionMetadataResponse::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(GetEventPredictionMetadataResponse::eventTypeName))
            .setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(GetEventPredictionMetadataResponse::entityId))
            .setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(GetEventPredictionMetadataResponse::entityType))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();

    private static final SdkField<String> EVENT_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTimestamp").getter(getter(GetEventPredictionMetadataResponse::eventTimestamp))
            .setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(GetEventPredictionMetadataResponse::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorVersionId").getter(getter(GetEventPredictionMetadataResponse::detectorVersionId))
            .setter(setter(Builder::detectorVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorVersionStatus").getter(getter(GetEventPredictionMetadataResponse::detectorVersionStatus))
            .setter(setter(Builder::detectorVersionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionStatus").build())
            .build();

    private static final SdkField<List<EventVariableSummary>> EVENT_VARIABLES_FIELD = SdkField
            .<List<EventVariableSummary>> builder(MarshallingType.LIST)
            .memberName("eventVariables")
            .getter(getter(GetEventPredictionMetadataResponse::eventVariables))
            .setter(setter(Builder::eventVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventVariableSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventVariableSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EvaluatedRule>> RULES_FIELD = SdkField
            .<List<EvaluatedRule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(GetEventPredictionMetadataResponse::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluatedRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluatedRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RULE_EXECUTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleExecutionMode").getter(getter(GetEventPredictionMetadataResponse::ruleExecutionModeAsString))
            .setter(setter(Builder::ruleExecutionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionMode").build()).build();

    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("outcomes")
            .getter(getter(GetEventPredictionMetadataResponse::outcomes))
            .setter(setter(Builder::outcomes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EvaluatedModelVersion>> EVALUATED_MODEL_VERSIONS_FIELD = SdkField
            .<List<EvaluatedModelVersion>> builder(MarshallingType.LIST)
            .memberName("evaluatedModelVersions")
            .getter(getter(GetEventPredictionMetadataResponse::evaluatedModelVersions))
            .setter(setter(Builder::evaluatedModelVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatedModelVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluatedModelVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluatedModelVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EvaluatedExternalModel>> EVALUATED_EXTERNAL_MODELS_FIELD = SdkField
            .<List<EvaluatedExternalModel>> builder(MarshallingType.LIST)
            .memberName("evaluatedExternalModels")
            .getter(getter(GetEventPredictionMetadataResponse::evaluatedExternalModels))
            .setter(setter(Builder::evaluatedExternalModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatedExternalModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluatedExternalModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluatedExternalModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREDICTION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("predictionTimestamp").getter(getter(GetEventPredictionMetadataResponse::predictionTimestamp))
            .setter(setter(Builder::predictionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_NAME_FIELD, ENTITY_ID_FIELD, ENTITY_TYPE_FIELD, EVENT_TIMESTAMP_FIELD, DETECTOR_ID_FIELD,
            DETECTOR_VERSION_ID_FIELD, DETECTOR_VERSION_STATUS_FIELD, EVENT_VARIABLES_FIELD, RULES_FIELD,
            RULE_EXECUTION_MODE_FIELD, OUTCOMES_FIELD, EVALUATED_MODEL_VERSIONS_FIELD, EVALUATED_EXTERNAL_MODELS_FIELD,
            PREDICTION_TIMESTAMP_FIELD));

    private final String eventId;

    private final String eventTypeName;

    private final String entityId;

    private final String entityType;

    private final String eventTimestamp;

    private final String detectorId;

    private final String detectorVersionId;

    private final String detectorVersionStatus;

    private final List<EventVariableSummary> eventVariables;

    private final List<EvaluatedRule> rules;

    private final String ruleExecutionMode;

    private final List<String> outcomes;

    private final List<EvaluatedModelVersion> evaluatedModelVersions;

    private final List<EvaluatedExternalModel> evaluatedExternalModels;

    private final String predictionTimestamp;

    private GetEventPredictionMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.eventTimestamp = builder.eventTimestamp;
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.detectorVersionStatus = builder.detectorVersionStatus;
        this.eventVariables = builder.eventVariables;
        this.rules = builder.rules;
        this.ruleExecutionMode = builder.ruleExecutionMode;
        this.outcomes = builder.outcomes;
        this.evaluatedModelVersions = builder.evaluatedModelVersions;
        this.evaluatedExternalModels = builder.evaluatedExternalModels;
        this.predictionTimestamp = builder.predictionTimestamp;
    }

    /**
     * <p>
     * The event ID.
     * </p>
     * 
     * @return The event ID.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type associated with the detector specified for this prediction.
     * </p>
     * 
     * @return The event type associated with the detector specified for this prediction.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The entity ID.
     * </p>
     * 
     * @return The entity ID.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The entity type.
     * </p>
     * 
     * @return The entity type.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * <p>
     * The timestamp for when the prediction was generated for the associated event ID.
     * </p>
     * 
     * @return The timestamp for when the prediction was generated for the associated event ID.
     */
    public final String eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector version ID.
     * </p>
     * 
     * @return The detector version ID.
     */
    public final String detectorVersionId() {
        return detectorVersionId;
    }

    /**
     * <p>
     * The status of the detector version.
     * </p>
     * 
     * @return The status of the detector version.
     */
    public final String detectorVersionStatus() {
        return detectorVersionStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventVariables() {
        return eventVariables != null && !(eventVariables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event variables that influenced the prediction scores.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventVariables} method.
     * </p>
     * 
     * @return A list of event variables that influenced the prediction scores.
     */
    public final List<EventVariableSummary> eventVariables() {
        return eventVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of rules associated with the detector version that were used for evaluating variable values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return List of rules associated with the detector version that were used for evaluating variable values.
     */
    public final List<EvaluatedRule> rules() {
        return rules;
    }

    /**
     * <p>
     * The execution mode of the rule used for evaluating variable values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleExecutionMode}
     * will return {@link RuleExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleExecutionModeAsString}.
     * </p>
     * 
     * @return The execution mode of the rule used for evaluating variable values.
     * @see RuleExecutionMode
     */
    public final RuleExecutionMode ruleExecutionMode() {
        return RuleExecutionMode.fromValue(ruleExecutionMode);
    }

    /**
     * <p>
     * The execution mode of the rule used for evaluating variable values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleExecutionMode}
     * will return {@link RuleExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleExecutionModeAsString}.
     * </p>
     * 
     * @return The execution mode of the rule used for evaluating variable values.
     * @see RuleExecutionMode
     */
    public final String ruleExecutionModeAsString() {
        return ruleExecutionMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outcomes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutcomes() {
        return outcomes != null && !(outcomes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outcomes of the matched rule, based on the rule execution mode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutcomes} method.
     * </p>
     * 
     * @return The outcomes of the matched rule, based on the rule execution mode.
     */
    public final List<String> outcomes() {
        return outcomes;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluatedModelVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEvaluatedModelVersions() {
        return evaluatedModelVersions != null && !(evaluatedModelVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Model versions that were evaluated for generating predictions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluatedModelVersions} method.
     * </p>
     * 
     * @return Model versions that were evaluated for generating predictions.
     */
    public final List<EvaluatedModelVersion> evaluatedModelVersions() {
        return evaluatedModelVersions;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluatedExternalModels property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEvaluatedExternalModels() {
        return evaluatedExternalModels != null && !(evaluatedExternalModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * External (Amazon SageMaker) models that were evaluated for generating predictions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluatedExternalModels} method.
     * </p>
     * 
     * @return External (Amazon SageMaker) models that were evaluated for generating predictions.
     */
    public final List<EvaluatedExternalModel> evaluatedExternalModels() {
        return evaluatedExternalModels;
    }

    /**
     * <p>
     * The timestamp that defines when the prediction was generated.
     * </p>
     * 
     * @return The timestamp that defines when the prediction was generated.
     */
    public final String predictionTimestamp() {
        return predictionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventVariables() ? eventVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleExecutionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutcomes() ? outcomes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluatedModelVersions() ? evaluatedModelVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluatedExternalModels() ? evaluatedExternalModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(predictionTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventPredictionMetadataResponse)) {
            return false;
        }
        GetEventPredictionMetadataResponse other = (GetEventPredictionMetadataResponse) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(entityId(), other.entityId()) && Objects.equals(entityType(), other.entityType())
                && Objects.equals(eventTimestamp(), other.eventTimestamp()) && Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(detectorVersionId(), other.detectorVersionId())
                && Objects.equals(detectorVersionStatus(), other.detectorVersionStatus())
                && hasEventVariables() == other.hasEventVariables() && Objects.equals(eventVariables(), other.eventVariables())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && Objects.equals(ruleExecutionModeAsString(), other.ruleExecutionModeAsString())
                && hasOutcomes() == other.hasOutcomes() && Objects.equals(outcomes(), other.outcomes())
                && hasEvaluatedModelVersions() == other.hasEvaluatedModelVersions()
                && Objects.equals(evaluatedModelVersions(), other.evaluatedModelVersions())
                && hasEvaluatedExternalModels() == other.hasEvaluatedExternalModels()
                && Objects.equals(evaluatedExternalModels(), other.evaluatedExternalModels())
                && Objects.equals(predictionTimestamp(), other.predictionTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEventPredictionMetadataResponse").add("EventId", eventId())
                .add("EventTypeName", eventTypeName()).add("EntityId", entityId()).add("EntityType", entityType())
                .add("EventTimestamp", eventTimestamp()).add("DetectorId", detectorId())
                .add("DetectorVersionId", detectorVersionId()).add("DetectorVersionStatus", detectorVersionStatus())
                .add("EventVariables", hasEventVariables() ? eventVariables() : null).add("Rules", hasRules() ? rules() : null)
                .add("RuleExecutionMode", ruleExecutionModeAsString()).add("Outcomes", hasOutcomes() ? outcomes() : null)
                .add("EvaluatedModelVersions", hasEvaluatedModelVersions() ? evaluatedModelVersions() : null)
                .add("EvaluatedExternalModels", hasEvaluatedExternalModels() ? evaluatedExternalModels() : null)
                .add("PredictionTimestamp", predictionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionId":
            return Optional.ofNullable(clazz.cast(detectorVersionId()));
        case "detectorVersionStatus":
            return Optional.ofNullable(clazz.cast(detectorVersionStatus()));
        case "eventVariables":
            return Optional.ofNullable(clazz.cast(eventVariables()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "ruleExecutionMode":
            return Optional.ofNullable(clazz.cast(ruleExecutionModeAsString()));
        case "outcomes":
            return Optional.ofNullable(clazz.cast(outcomes()));
        case "evaluatedModelVersions":
            return Optional.ofNullable(clazz.cast(evaluatedModelVersions()));
        case "evaluatedExternalModels":
            return Optional.ofNullable(clazz.cast(evaluatedExternalModels()));
        case "predictionTimestamp":
            return Optional.ofNullable(clazz.cast(predictionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventPredictionMetadataResponse, T> g) {
        return obj -> g.apply((GetEventPredictionMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEventPredictionMetadataResponse> {
        /**
         * <p>
         * The event ID.
         * </p>
         * 
         * @param eventId
         *        The event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event type associated with the detector specified for this prediction.
         * </p>
         * 
         * @param eventTypeName
         *        The event type associated with the detector specified for this prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The entity ID.
         * </p>
         * 
         * @param entityId
         *        The entity ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The entity type.
         * </p>
         * 
         * @param entityType
         *        The entity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The timestamp for when the prediction was generated for the associated event ID.
         * </p>
         * 
         * @param eventTimestamp
         *        The timestamp for when the prediction was generated for the associated event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(String eventTimestamp);

        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The detector version ID.
         * </p>
         * 
         * @param detectorVersionId
         *        The detector version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionId(String detectorVersionId);

        /**
         * <p>
         * The status of the detector version.
         * </p>
         * 
         * @param detectorVersionStatus
         *        The status of the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionStatus(String detectorVersionStatus);

        /**
         * <p>
         * A list of event variables that influenced the prediction scores.
         * </p>
         * 
         * @param eventVariables
         *        A list of event variables that influenced the prediction scores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventVariables(Collection<EventVariableSummary> eventVariables);

        /**
         * <p>
         * A list of event variables that influenced the prediction scores.
         * </p>
         * 
         * @param eventVariables
         *        A list of event variables that influenced the prediction scores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventVariables(EventVariableSummary... eventVariables);

        /**
         * <p>
         * A list of event variables that influenced the prediction scores.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.EventVariableSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.frauddetector.model.EventVariableSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.EventVariableSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #eventVariables(List<EventVariableSummary>)}.
         * 
         * @param eventVariables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.EventVariableSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventVariables(java.util.Collection<EventVariableSummary>)
         */
        Builder eventVariables(Consumer<EventVariableSummary.Builder>... eventVariables);

        /**
         * <p>
         * List of rules associated with the detector version that were used for evaluating variable values.
         * </p>
         * 
         * @param rules
         *        List of rules associated with the detector version that were used for evaluating variable values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<EvaluatedRule> rules);

        /**
         * <p>
         * List of rules associated with the detector version that were used for evaluating variable values.
         * </p>
         * 
         * @param rules
         *        List of rules associated with the detector version that were used for evaluating variable values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(EvaluatedRule... rules);

        /**
         * <p>
         * List of rules associated with the detector version that were used for evaluating variable values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedRule.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<EvaluatedRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<EvaluatedRule>)
         */
        Builder rules(Consumer<EvaluatedRule.Builder>... rules);

        /**
         * <p>
         * The execution mode of the rule used for evaluating variable values.
         * </p>
         * 
         * @param ruleExecutionMode
         *        The execution mode of the rule used for evaluating variable values.
         * @see RuleExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionMode
         */
        Builder ruleExecutionMode(String ruleExecutionMode);

        /**
         * <p>
         * The execution mode of the rule used for evaluating variable values.
         * </p>
         * 
         * @param ruleExecutionMode
         *        The execution mode of the rule used for evaluating variable values.
         * @see RuleExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionMode
         */
        Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode);

        /**
         * <p>
         * The outcomes of the matched rule, based on the rule execution mode.
         * </p>
         * 
         * @param outcomes
         *        The outcomes of the matched rule, based on the rule execution mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(Collection<String> outcomes);

        /**
         * <p>
         * The outcomes of the matched rule, based on the rule execution mode.
         * </p>
         * 
         * @param outcomes
         *        The outcomes of the matched rule, based on the rule execution mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(String... outcomes);

        /**
         * <p>
         * Model versions that were evaluated for generating predictions.
         * </p>
         * 
         * @param evaluatedModelVersions
         *        Model versions that were evaluated for generating predictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatedModelVersions(Collection<EvaluatedModelVersion> evaluatedModelVersions);

        /**
         * <p>
         * Model versions that were evaluated for generating predictions.
         * </p>
         * 
         * @param evaluatedModelVersions
         *        Model versions that were evaluated for generating predictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatedModelVersions(EvaluatedModelVersion... evaluatedModelVersions);

        /**
         * <p>
         * Model versions that were evaluated for generating predictions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedModelVersion.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedModelVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedModelVersion.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluatedModelVersions(List<EvaluatedModelVersion>)}.
         * 
         * @param evaluatedModelVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedModelVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluatedModelVersions(java.util.Collection<EvaluatedModelVersion>)
         */
        Builder evaluatedModelVersions(Consumer<EvaluatedModelVersion.Builder>... evaluatedModelVersions);

        /**
         * <p>
         * External (Amazon SageMaker) models that were evaluated for generating predictions.
         * </p>
         * 
         * @param evaluatedExternalModels
         *        External (Amazon SageMaker) models that were evaluated for generating predictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatedExternalModels(Collection<EvaluatedExternalModel> evaluatedExternalModels);

        /**
         * <p>
         * External (Amazon SageMaker) models that were evaluated for generating predictions.
         * </p>
         * 
         * @param evaluatedExternalModels
         *        External (Amazon SageMaker) models that were evaluated for generating predictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatedExternalModels(EvaluatedExternalModel... evaluatedExternalModels);

        /**
         * <p>
         * External (Amazon SageMaker) models that were evaluated for generating predictions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedExternalModel.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedExternalModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedExternalModel.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluatedExternalModels(List<EvaluatedExternalModel>)}.
         * 
         * @param evaluatedExternalModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.EvaluatedExternalModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluatedExternalModels(java.util.Collection<EvaluatedExternalModel>)
         */
        Builder evaluatedExternalModels(Consumer<EvaluatedExternalModel.Builder>... evaluatedExternalModels);

        /**
         * <p>
         * The timestamp that defines when the prediction was generated.
         * </p>
         * 
         * @param predictionTimestamp
         *        The timestamp that defines when the prediction was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionTimestamp(String predictionTimestamp);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private String eventId;

        private String eventTypeName;

        private String entityId;

        private String entityType;

        private String eventTimestamp;

        private String detectorId;

        private String detectorVersionId;

        private String detectorVersionStatus;

        private List<EventVariableSummary> eventVariables = DefaultSdkAutoConstructList.getInstance();

        private List<EvaluatedRule> rules = DefaultSdkAutoConstructList.getInstance();

        private String ruleExecutionMode;

        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();

        private List<EvaluatedModelVersion> evaluatedModelVersions = DefaultSdkAutoConstructList.getInstance();

        private List<EvaluatedExternalModel> evaluatedExternalModels = DefaultSdkAutoConstructList.getInstance();

        private String predictionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventPredictionMetadataResponse model) {
            super(model);
            eventId(model.eventId);
            eventTypeName(model.eventTypeName);
            entityId(model.entityId);
            entityType(model.entityType);
            eventTimestamp(model.eventTimestamp);
            detectorId(model.detectorId);
            detectorVersionId(model.detectorVersionId);
            detectorVersionStatus(model.detectorVersionStatus);
            eventVariables(model.eventVariables);
            rules(model.rules);
            ruleExecutionMode(model.ruleExecutionMode);
            outcomes(model.outcomes);
            evaluatedModelVersions(model.evaluatedModelVersions);
            evaluatedExternalModels(model.evaluatedExternalModels);
            predictionTimestamp(model.predictionTimestamp);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final String getDetectorVersionStatus() {
            return detectorVersionStatus;
        }

        public final void setDetectorVersionStatus(String detectorVersionStatus) {
            this.detectorVersionStatus = detectorVersionStatus;
        }

        @Override
        public final Builder detectorVersionStatus(String detectorVersionStatus) {
            this.detectorVersionStatus = detectorVersionStatus;
            return this;
        }

        public final List<EventVariableSummary.Builder> getEventVariables() {
            List<EventVariableSummary.Builder> result = ListOfEventVariableSummariesCopier.copyToBuilder(this.eventVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventVariables(Collection<EventVariableSummary.BuilderImpl> eventVariables) {
            this.eventVariables = ListOfEventVariableSummariesCopier.copyFromBuilder(eventVariables);
        }

        @Override
        public final Builder eventVariables(Collection<EventVariableSummary> eventVariables) {
            this.eventVariables = ListOfEventVariableSummariesCopier.copy(eventVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventVariables(EventVariableSummary... eventVariables) {
            eventVariables(Arrays.asList(eventVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventVariables(Consumer<EventVariableSummary.Builder>... eventVariables) {
            eventVariables(Stream.of(eventVariables).map(c -> EventVariableSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EvaluatedRule.Builder> getRules() {
            List<EvaluatedRule.Builder> result = EvaluatedRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<EvaluatedRule.BuilderImpl> rules) {
            this.rules = EvaluatedRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<EvaluatedRule> rules) {
            this.rules = EvaluatedRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(EvaluatedRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<EvaluatedRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> EvaluatedRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRuleExecutionMode() {
            return ruleExecutionMode;
        }

        public final void setRuleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
        }

        @Override
        public final Builder ruleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
            return this;
        }

        @Override
        public final Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode) {
            this.ruleExecutionMode(ruleExecutionMode == null ? null : ruleExecutionMode.toString());
            return this;
        }

        public final Collection<String> getOutcomes() {
            if (outcomes instanceof SdkAutoConstructList) {
                return null;
            }
            return outcomes;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
        }

        @Override
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(String... outcomes) {
            outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final List<EvaluatedModelVersion.Builder> getEvaluatedModelVersions() {
            List<EvaluatedModelVersion.Builder> result = ListOfEvaluatedModelVersionsCopier
                    .copyToBuilder(this.evaluatedModelVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluatedModelVersions(Collection<EvaluatedModelVersion.BuilderImpl> evaluatedModelVersions) {
            this.evaluatedModelVersions = ListOfEvaluatedModelVersionsCopier.copyFromBuilder(evaluatedModelVersions);
        }

        @Override
        public final Builder evaluatedModelVersions(Collection<EvaluatedModelVersion> evaluatedModelVersions) {
            this.evaluatedModelVersions = ListOfEvaluatedModelVersionsCopier.copy(evaluatedModelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluatedModelVersions(EvaluatedModelVersion... evaluatedModelVersions) {
            evaluatedModelVersions(Arrays.asList(evaluatedModelVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluatedModelVersions(Consumer<EvaluatedModelVersion.Builder>... evaluatedModelVersions) {
            evaluatedModelVersions(Stream.of(evaluatedModelVersions)
                    .map(c -> EvaluatedModelVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EvaluatedExternalModel.Builder> getEvaluatedExternalModels() {
            List<EvaluatedExternalModel.Builder> result = ListOfEvaluatedExternalModelsCopier
                    .copyToBuilder(this.evaluatedExternalModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluatedExternalModels(Collection<EvaluatedExternalModel.BuilderImpl> evaluatedExternalModels) {
            this.evaluatedExternalModels = ListOfEvaluatedExternalModelsCopier.copyFromBuilder(evaluatedExternalModels);
        }

        @Override
        public final Builder evaluatedExternalModels(Collection<EvaluatedExternalModel> evaluatedExternalModels) {
            this.evaluatedExternalModels = ListOfEvaluatedExternalModelsCopier.copy(evaluatedExternalModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluatedExternalModels(EvaluatedExternalModel... evaluatedExternalModels) {
            evaluatedExternalModels(Arrays.asList(evaluatedExternalModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluatedExternalModels(Consumer<EvaluatedExternalModel.Builder>... evaluatedExternalModels) {
            evaluatedExternalModels(Stream.of(evaluatedExternalModels)
                    .map(c -> EvaluatedExternalModel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPredictionTimestamp() {
            return predictionTimestamp;
        }

        public final void setPredictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
        }

        @Override
        public final Builder predictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
            return this;
        }

        @Override
        public GetEventPredictionMetadataResponse build() {
            return new GetEventPredictionMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
