/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event type details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventType implements SdkPojo, Serializable, ToCopyableBuilder<EventType.Builder, EventType> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EventType::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EventType::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> EVENT_VARIABLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventVariables")
            .getter(getter(EventType::eventVariables))
            .setter(setter(Builder::eventVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("labels")
            .getter(getter(EventType::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENTITY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entityTypes")
            .getter(getter(EventType::entityTypes))
            .setter(setter(Builder::entityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVENT_INGESTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventIngestion").getter(getter(EventType::eventIngestionAsString))
            .setter(setter(Builder::eventIngestion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventIngestion").build()).build();

    private static final SdkField<IngestedEventStatistics> INGESTED_EVENT_STATISTICS_FIELD = SdkField
            .<IngestedEventStatistics> builder(MarshallingType.SDK_POJO).memberName("ingestedEventStatistics")
            .getter(getter(EventType::ingestedEventStatistics)).setter(setter(Builder::ingestedEventStatistics))
            .constructor(IngestedEventStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestedEventStatistics").build())
            .build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedTime").getter(getter(EventType::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdTime").getter(getter(EventType::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EventType::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<EventOrchestration> EVENT_ORCHESTRATION_FIELD = SdkField
            .<EventOrchestration> builder(MarshallingType.SDK_POJO).memberName("eventOrchestration")
            .getter(getter(EventType::eventOrchestration)).setter(setter(Builder::eventOrchestration))
            .constructor(EventOrchestration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventOrchestration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            EVENT_VARIABLES_FIELD, LABELS_FIELD, ENTITY_TYPES_FIELD, EVENT_INGESTION_FIELD, INGESTED_EVENT_STATISTICS_FIELD,
            LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD, EVENT_ORCHESTRATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final List<String> eventVariables;

    private final List<String> labels;

    private final List<String> entityTypes;

    private final String eventIngestion;

    private final IngestedEventStatistics ingestedEventStatistics;

    private final String lastUpdatedTime;

    private final String createdTime;

    private final String arn;

    private final EventOrchestration eventOrchestration;

    private EventType(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.eventVariables = builder.eventVariables;
        this.labels = builder.labels;
        this.entityTypes = builder.entityTypes;
        this.eventIngestion = builder.eventIngestion;
        this.ingestedEventStatistics = builder.ingestedEventStatistics;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
        this.eventOrchestration = builder.eventOrchestration;
    }

    /**
     * <p>
     * The event type name.
     * </p>
     * 
     * @return The event type name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The event type description.
     * </p>
     * 
     * @return The event type description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventVariables() {
        return eventVariables != null && !(eventVariables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event type event variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventVariables} method.
     * </p>
     * 
     * @return The event type event variables.
     */
    public final List<String> eventVariables() {
        return eventVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event type labels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return The event type labels.
     */
    public final List<String> labels() {
        return labels;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityTypes() {
        return entityTypes != null && !(entityTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event type entity types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityTypes} method.
     * </p>
     * 
     * @return The event type entity types.
     */
    public final List<String> entityTypes() {
        return entityTypes;
    }

    /**
     * <p>
     * If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses that
     * data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known as
     * <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventIngestion}
     * will return {@link EventIngestion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventIngestionAsString}.
     * </p>
     * 
     * @return If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses
     *         that data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known
     *         as <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.
     * @see EventIngestion
     */
    public final EventIngestion eventIngestion() {
        return EventIngestion.fromValue(eventIngestion);
    }

    /**
     * <p>
     * If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses that
     * data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known as
     * <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventIngestion}
     * will return {@link EventIngestion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventIngestionAsString}.
     * </p>
     * 
     * @return If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses
     *         that data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known
     *         as <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.
     * @see EventIngestion
     */
    public final String eventIngestionAsString() {
        return eventIngestion;
    }

    /**
     * <p>
     * Data about the stored events.
     * </p>
     * 
     * @return Data about the stored events.
     */
    public final IngestedEventStatistics ingestedEventStatistics() {
        return ingestedEventStatistics;
    }

    /**
     * <p>
     * Timestamp of when the event type was last updated.
     * </p>
     * 
     * @return Timestamp of when the event type was last updated.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Timestamp of when the event type was created.
     * </p>
     * 
     * @return Timestamp of when the event type was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The entity type ARN.
     * </p>
     * 
     * @return The entity type ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The event orchestration status.
     * </p>
     * 
     * @return The event orchestration status.
     */
    public final EventOrchestration eventOrchestration() {
        return eventOrchestration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventVariables() ? eventVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityTypes() ? entityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventIngestionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ingestedEventStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(eventOrchestration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventType)) {
            return false;
        }
        EventType other = (EventType) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasEventVariables() == other.hasEventVariables() && Objects.equals(eventVariables(), other.eventVariables())
                && hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && hasEntityTypes() == other.hasEntityTypes() && Objects.equals(entityTypes(), other.entityTypes())
                && Objects.equals(eventIngestionAsString(), other.eventIngestionAsString())
                && Objects.equals(ingestedEventStatistics(), other.ingestedEventStatistics())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(arn(), other.arn())
                && Objects.equals(eventOrchestration(), other.eventOrchestration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventType").add("Name", name()).add("Description", description())
                .add("EventVariables", hasEventVariables() ? eventVariables() : null)
                .add("Labels", hasLabels() ? labels() : null).add("EntityTypes", hasEntityTypes() ? entityTypes() : null)
                .add("EventIngestion", eventIngestionAsString()).add("IngestedEventStatistics", ingestedEventStatistics())
                .add("LastUpdatedTime", lastUpdatedTime()).add("CreatedTime", createdTime()).add("Arn", arn())
                .add("EventOrchestration", eventOrchestration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "eventVariables":
            return Optional.ofNullable(clazz.cast(eventVariables()));
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "entityTypes":
            return Optional.ofNullable(clazz.cast(entityTypes()));
        case "eventIngestion":
            return Optional.ofNullable(clazz.cast(eventIngestionAsString()));
        case "ingestedEventStatistics":
            return Optional.ofNullable(clazz.cast(ingestedEventStatistics()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "eventOrchestration":
            return Optional.ofNullable(clazz.cast(eventOrchestration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventType, T> g) {
        return obj -> g.apply((EventType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventType> {
        /**
         * <p>
         * The event type name.
         * </p>
         * 
         * @param name
         *        The event type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The event type description.
         * </p>
         * 
         * @param description
         *        The event type description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The event type event variables.
         * </p>
         * 
         * @param eventVariables
         *        The event type event variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventVariables(Collection<String> eventVariables);

        /**
         * <p>
         * The event type event variables.
         * </p>
         * 
         * @param eventVariables
         *        The event type event variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventVariables(String... eventVariables);

        /**
         * <p>
         * The event type labels.
         * </p>
         * 
         * @param labels
         *        The event type labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * The event type labels.
         * </p>
         * 
         * @param labels
         *        The event type labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        /**
         * <p>
         * The event type entity types.
         * </p>
         * 
         * @param entityTypes
         *        The event type entity types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(Collection<String> entityTypes);

        /**
         * <p>
         * The event type entity types.
         * </p>
         * 
         * @param entityTypes
         *        The event type entity types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(String... entityTypes);

        /**
         * <p>
         * If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses that
         * data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known as
         * <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.
         * </p>
         * 
         * @param eventIngestion
         *        If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and
         *        uses that data to update calculated variables in near real-time. Amazon Fraud Detector uses this data,
         *        known as <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.
         * @see EventIngestion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventIngestion
         */
        Builder eventIngestion(String eventIngestion);

        /**
         * <p>
         * If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses that
         * data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known as
         * <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.
         * </p>
         * 
         * @param eventIngestion
         *        If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and
         *        uses that data to update calculated variables in near real-time. Amazon Fraud Detector uses this data,
         *        known as <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.
         * @see EventIngestion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventIngestion
         */
        Builder eventIngestion(EventIngestion eventIngestion);

        /**
         * <p>
         * Data about the stored events.
         * </p>
         * 
         * @param ingestedEventStatistics
         *        Data about the stored events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestedEventStatistics(IngestedEventStatistics ingestedEventStatistics);

        /**
         * <p>
         * Data about the stored events.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestedEventStatistics.Builder} avoiding
         * the need to create one manually via {@link IngestedEventStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestedEventStatistics.Builder#build()} is called immediately
         * and its result is passed to {@link #ingestedEventStatistics(IngestedEventStatistics)}.
         * 
         * @param ingestedEventStatistics
         *        a consumer that will call methods on {@link IngestedEventStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestedEventStatistics(IngestedEventStatistics)
         */
        default Builder ingestedEventStatistics(Consumer<IngestedEventStatistics.Builder> ingestedEventStatistics) {
            return ingestedEventStatistics(IngestedEventStatistics.builder().applyMutation(ingestedEventStatistics).build());
        }

        /**
         * <p>
         * Timestamp of when the event type was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        Timestamp of when the event type was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * Timestamp of when the event type was created.
         * </p>
         * 
         * @param createdTime
         *        Timestamp of when the event type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The entity type ARN.
         * </p>
         * 
         * @param arn
         *        The entity type ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The event orchestration status.
         * </p>
         * 
         * @param eventOrchestration
         *        The event orchestration status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventOrchestration(EventOrchestration eventOrchestration);

        /**
         * <p>
         * The event orchestration status.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventOrchestration.Builder} avoiding the
         * need to create one manually via {@link EventOrchestration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventOrchestration.Builder#build()} is called immediately and its
         * result is passed to {@link #eventOrchestration(EventOrchestration)}.
         * 
         * @param eventOrchestration
         *        a consumer that will call methods on {@link EventOrchestration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventOrchestration(EventOrchestration)
         */
        default Builder eventOrchestration(Consumer<EventOrchestration.Builder> eventOrchestration) {
            return eventOrchestration(EventOrchestration.builder().applyMutation(eventOrchestration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<String> eventVariables = DefaultSdkAutoConstructList.getInstance();

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private List<String> entityTypes = DefaultSdkAutoConstructList.getInstance();

        private String eventIngestion;

        private IngestedEventStatistics ingestedEventStatistics;

        private String lastUpdatedTime;

        private String createdTime;

        private String arn;

        private EventOrchestration eventOrchestration;

        private BuilderImpl() {
        }

        private BuilderImpl(EventType model) {
            name(model.name);
            description(model.description);
            eventVariables(model.eventVariables);
            labels(model.labels);
            entityTypes(model.entityTypes);
            eventIngestion(model.eventIngestion);
            ingestedEventStatistics(model.ingestedEventStatistics);
            lastUpdatedTime(model.lastUpdatedTime);
            createdTime(model.createdTime);
            arn(model.arn);
            eventOrchestration(model.eventOrchestration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEventVariables() {
            if (eventVariables instanceof SdkAutoConstructList) {
                return null;
            }
            return eventVariables;
        }

        public final void setEventVariables(Collection<String> eventVariables) {
            this.eventVariables = ListOfStringsCopier.copy(eventVariables);
        }

        @Override
        public final Builder eventVariables(Collection<String> eventVariables) {
            this.eventVariables = ListOfStringsCopier.copy(eventVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventVariables(String... eventVariables) {
            eventVariables(Arrays.asList(eventVariables));
            return this;
        }

        public final Collection<String> getLabels() {
            if (labels instanceof SdkAutoConstructList) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ListOfStringsCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ListOfStringsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final Collection<String> getEntityTypes() {
            if (entityTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return entityTypes;
        }

        public final void setEntityTypes(Collection<String> entityTypes) {
            this.entityTypes = NonEmptyListOfStringsCopier.copy(entityTypes);
        }

        @Override
        public final Builder entityTypes(Collection<String> entityTypes) {
            this.entityTypes = NonEmptyListOfStringsCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(String... entityTypes) {
            entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        public final String getEventIngestion() {
            return eventIngestion;
        }

        public final void setEventIngestion(String eventIngestion) {
            this.eventIngestion = eventIngestion;
        }

        @Override
        public final Builder eventIngestion(String eventIngestion) {
            this.eventIngestion = eventIngestion;
            return this;
        }

        @Override
        public final Builder eventIngestion(EventIngestion eventIngestion) {
            this.eventIngestion(eventIngestion == null ? null : eventIngestion.toString());
            return this;
        }

        public final IngestedEventStatistics.Builder getIngestedEventStatistics() {
            return ingestedEventStatistics != null ? ingestedEventStatistics.toBuilder() : null;
        }

        public final void setIngestedEventStatistics(IngestedEventStatistics.BuilderImpl ingestedEventStatistics) {
            this.ingestedEventStatistics = ingestedEventStatistics != null ? ingestedEventStatistics.build() : null;
        }

        @Override
        public final Builder ingestedEventStatistics(IngestedEventStatistics ingestedEventStatistics) {
            this.ingestedEventStatistics = ingestedEventStatistics;
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final EventOrchestration.Builder getEventOrchestration() {
            return eventOrchestration != null ? eventOrchestration.toBuilder() : null;
        }

        public final void setEventOrchestration(EventOrchestration.BuilderImpl eventOrchestration) {
            this.eventOrchestration = eventOrchestration != null ? eventOrchestration.build() : null;
        }

        @Override
        public final Builder eventOrchestration(EventOrchestration eventOrchestration) {
            this.eventOrchestration = eventOrchestration;
            return this;
        }

        @Override
        public EventType build() {
            return new EventType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
