/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse;

public class ListTagsForResourceIterable
implements SdkIterable<ListTagsForResourceResponse> {
    private final FraudDetectorClient client;
    private final ListTagsForResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagsForResourceIterable(FraudDetectorClient client, ListTagsForResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTagsForResourceResponseFetcher();
    }

    public Iterator<ListTagsForResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTagsForResourceResponseFetcher
    implements SyncPageFetcher<ListTagsForResourceResponse> {
        private ListTagsForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsForResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTagsForResourceResponse nextPage(ListTagsForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListTagsForResourceIterable.this.client.listTagsForResource(ListTagsForResourceIterable.this.firstRequest);
            }
            return ListTagsForResourceIterable.this.client.listTagsForResource((ListTagsForResourceRequest)((Object)ListTagsForResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

