/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.TFIMetricDataPoint;
import software.amazon.awssdk.services.frauddetector.model.TFIMetricDataPointsListCopier;
import software.amazon.awssdk.services.frauddetector.model.TFIModelPerformance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TFITrainingMetricsValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TFITrainingMetricsValue> {
    private static final SdkField<List<TFIMetricDataPoint>> METRIC_DATA_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricDataPoints").getter(TFITrainingMetricsValue.getter(TFITrainingMetricsValue::metricDataPoints)).setter(TFITrainingMetricsValue.setter(Builder::metricDataPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDataPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TFIMetricDataPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TFIModelPerformance> MODEL_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelPerformance").getter(TFITrainingMetricsValue.getter(TFITrainingMetricsValue::modelPerformance)).setter(TFITrainingMetricsValue.setter(Builder::modelPerformance)).constructor(TFIModelPerformance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelPerformance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_POINTS_FIELD, MODEL_PERFORMANCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TFIMetricDataPoint> metricDataPoints;
    private final TFIModelPerformance modelPerformance;

    private TFITrainingMetricsValue(BuilderImpl builder) {
        this.metricDataPoints = builder.metricDataPoints;
        this.modelPerformance = builder.modelPerformance;
    }

    public final boolean hasMetricDataPoints() {
        return this.metricDataPoints != null && !(this.metricDataPoints instanceof SdkAutoConstructList);
    }

    public final List<TFIMetricDataPoint> metricDataPoints() {
        return this.metricDataPoints;
    }

    public final TFIModelPerformance modelPerformance() {
        return this.modelPerformance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDataPoints() ? this.metricDataPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPerformance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TFITrainingMetricsValue)) {
            return false;
        }
        TFITrainingMetricsValue other = (TFITrainingMetricsValue)obj;
        return this.hasMetricDataPoints() == other.hasMetricDataPoints() && Objects.equals(this.metricDataPoints(), other.metricDataPoints()) && Objects.equals(this.modelPerformance(), other.modelPerformance());
    }

    public final String toString() {
        return ToString.builder((String)"TFITrainingMetricsValue").add("MetricDataPoints", this.hasMetricDataPoints() ? this.metricDataPoints() : null).add("ModelPerformance", (Object)this.modelPerformance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricDataPoints": {
                return Optional.ofNullable(clazz.cast(this.metricDataPoints()));
            }
            case "modelPerformance": {
                return Optional.ofNullable(clazz.cast(this.modelPerformance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TFITrainingMetricsValue, T> g) {
        return obj -> g.apply((TFITrainingMetricsValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TFIMetricDataPoint> metricDataPoints = DefaultSdkAutoConstructList.getInstance();
        private TFIModelPerformance modelPerformance;

        private BuilderImpl() {
        }

        private BuilderImpl(TFITrainingMetricsValue model) {
            this.metricDataPoints(model.metricDataPoints);
            this.modelPerformance(model.modelPerformance);
        }

        public final List<TFIMetricDataPoint.Builder> getMetricDataPoints() {
            List<TFIMetricDataPoint.Builder> result = TFIMetricDataPointsListCopier.copyToBuilder(this.metricDataPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataPoints(Collection<TFIMetricDataPoint.BuilderImpl> metricDataPoints) {
            this.metricDataPoints = TFIMetricDataPointsListCopier.copyFromBuilder(metricDataPoints);
        }

        @Override
        public final Builder metricDataPoints(Collection<TFIMetricDataPoint> metricDataPoints) {
            this.metricDataPoints = TFIMetricDataPointsListCopier.copy(metricDataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(TFIMetricDataPoint ... metricDataPoints) {
            this.metricDataPoints(Arrays.asList(metricDataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(Consumer<TFIMetricDataPoint.Builder> ... metricDataPoints) {
            this.metricDataPoints(Stream.of(metricDataPoints).map(c -> (TFIMetricDataPoint)((TFIMetricDataPoint.Builder)TFIMetricDataPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TFIModelPerformance.Builder getModelPerformance() {
            return this.modelPerformance != null ? this.modelPerformance.toBuilder() : null;
        }

        public final void setModelPerformance(TFIModelPerformance.BuilderImpl modelPerformance) {
            this.modelPerformance = modelPerformance != null ? modelPerformance.build() : null;
        }

        @Override
        public final Builder modelPerformance(TFIModelPerformance modelPerformance) {
            this.modelPerformance = modelPerformance;
            return this;
        }

        public TFITrainingMetricsValue build() {
            return new TFITrainingMetricsValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TFITrainingMetricsValue> {
        public Builder metricDataPoints(Collection<TFIMetricDataPoint> var1);

        public Builder metricDataPoints(TFIMetricDataPoint ... var1);

        public Builder metricDataPoints(Consumer<TFIMetricDataPoint.Builder> ... var1);

        public Builder modelPerformance(TFIModelPerformance var1);

        default public Builder modelPerformance(Consumer<TFIModelPerformance.Builder> modelPerformance) {
            return this.modelPerformance((TFIModelPerformance)((TFIModelPerformance.Builder)TFIModelPerformance.builder().applyMutation(modelPerformance)).build());
        }
    }
}

