/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.AsyncJobStatus;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeleteEventsByEventTypeStatusResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetDeleteEventsByEventTypeStatusResponse> {
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(GetDeleteEventsByEventTypeStatusResponse.getter(GetDeleteEventsByEventTypeStatusResponse::eventTypeName)).setter(GetDeleteEventsByEventTypeStatusResponse.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> EVENTS_DELETION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventsDeletionStatus").getter(GetDeleteEventsByEventTypeStatusResponse.getter(GetDeleteEventsByEventTypeStatusResponse::eventsDeletionStatusAsString)).setter(GetDeleteEventsByEventTypeStatusResponse.setter(Builder::eventsDeletionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventsDeletionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_NAME_FIELD, EVENTS_DELETION_STATUS_FIELD));
    private final String eventTypeName;
    private final String eventsDeletionStatus;

    private GetDeleteEventsByEventTypeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.eventTypeName = builder.eventTypeName;
        this.eventsDeletionStatus = builder.eventsDeletionStatus;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final AsyncJobStatus eventsDeletionStatus() {
        return AsyncJobStatus.fromValue(this.eventsDeletionStatus);
    }

    public final String eventsDeletionStatusAsString() {
        return this.eventsDeletionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsDeletionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeleteEventsByEventTypeStatusResponse)) {
            return false;
        }
        GetDeleteEventsByEventTypeStatusResponse other = (GetDeleteEventsByEventTypeStatusResponse)((Object)obj);
        return Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.eventsDeletionStatusAsString(), other.eventsDeletionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeleteEventsByEventTypeStatusResponse").add("EventTypeName", (Object)this.eventTypeName()).add("EventsDeletionStatus", (Object)this.eventsDeletionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "eventsDeletionStatus": {
                return Optional.ofNullable(clazz.cast(this.eventsDeletionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeleteEventsByEventTypeStatusResponse, T> g) {
        return obj -> g.apply((GetDeleteEventsByEventTypeStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private String eventTypeName;
        private String eventsDeletionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeleteEventsByEventTypeStatusResponse model) {
            super(model);
            this.eventTypeName(model.eventTypeName);
            this.eventsDeletionStatus(model.eventsDeletionStatus);
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEventsDeletionStatus() {
            return this.eventsDeletionStatus;
        }

        public final void setEventsDeletionStatus(String eventsDeletionStatus) {
            this.eventsDeletionStatus = eventsDeletionStatus;
        }

        @Override
        public final Builder eventsDeletionStatus(String eventsDeletionStatus) {
            this.eventsDeletionStatus = eventsDeletionStatus;
            return this;
        }

        @Override
        public final Builder eventsDeletionStatus(AsyncJobStatus eventsDeletionStatus) {
            this.eventsDeletionStatus(eventsDeletionStatus == null ? null : eventsDeletionStatus.toString());
            return this;
        }

        @Override
        public GetDeleteEventsByEventTypeStatusResponse build() {
            return new GetDeleteEventsByEventTypeStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeleteEventsByEventTypeStatusResponse> {
        public Builder eventTypeName(String var1);

        public Builder eventsDeletionStatus(String var1);

        public Builder eventsDeletionStatus(AsyncJobStatus var1);
    }
}

