/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse;

public class GetVariablesIterable
implements SdkIterable<GetVariablesResponse> {
    private final FraudDetectorClient client;
    private final GetVariablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetVariablesIterable(FraudDetectorClient client, GetVariablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetVariablesResponseFetcher();
    }

    public Iterator<GetVariablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetVariablesResponseFetcher
    implements SyncPageFetcher<GetVariablesResponse> {
        private GetVariablesResponseFetcher() {
        }

        public boolean hasNextPage(GetVariablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetVariablesResponse nextPage(GetVariablesResponse previousPage) {
            if (previousPage == null) {
                return GetVariablesIterable.this.client.getVariables(GetVariablesIterable.this.firstRequest);
            }
            return GetVariablesIterable.this.client.getVariables((GetVariablesRequest)((Object)GetVariablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

