/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsRequest;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsResponse;
import software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary;

public class ListWhatIfForecastExportsPublisher
implements SdkPublisher<ListWhatIfForecastExportsResponse> {
    private final ForecastAsyncClient client;
    private final ListWhatIfForecastExportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWhatIfForecastExportsPublisher(ForecastAsyncClient client, ListWhatIfForecastExportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWhatIfForecastExportsPublisher(ForecastAsyncClient client, ListWhatIfForecastExportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWhatIfForecastExportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWhatIfForecastExportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WhatIfForecastExportSummary> whatIfForecastExports() {
        Function<ListWhatIfForecastExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.whatIfForecastExports() != null) {
                return response.whatIfForecastExports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWhatIfForecastExportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWhatIfForecastExportsResponseFetcher
    implements AsyncPageFetcher<ListWhatIfForecastExportsResponse> {
        private ListWhatIfForecastExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListWhatIfForecastExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWhatIfForecastExportsResponse> nextPage(ListWhatIfForecastExportsResponse previousPage) {
            if (previousPage == null) {
                return ListWhatIfForecastExportsPublisher.this.client.listWhatIfForecastExports(ListWhatIfForecastExportsPublisher.this.firstRequest);
            }
            return ListWhatIfForecastExportsPublisher.this.client.listWhatIfForecastExports((ListWhatIfForecastExportsRequest)((Object)ListWhatIfForecastExportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

