/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatasetType {
    TARGET_TIME_SERIES("TARGET_TIME_SERIES"),
    RELATED_TIME_SERIES("RELATED_TIME_SERIES"),
    ITEM_METADATA("ITEM_METADATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatasetType> VALUE_MAP;
    private final String value;

    private DatasetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatasetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatasetType> knownValues() {
        EnumSet<DatasetType> knownValues = EnumSet.allOf(DatasetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatasetType.class, DatasetType::toString);
    }
}

