/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsRequest;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsResponse;
import software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary;

public class ListWhatIfForecastsPublisher
implements SdkPublisher<ListWhatIfForecastsResponse> {
    private final ForecastAsyncClient client;
    private final ListWhatIfForecastsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWhatIfForecastsPublisher(ForecastAsyncClient client, ListWhatIfForecastsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWhatIfForecastsPublisher(ForecastAsyncClient client, ListWhatIfForecastsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWhatIfForecastsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWhatIfForecastsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WhatIfForecastSummary> whatIfForecasts() {
        Function<ListWhatIfForecastsResponse, Iterator> getIterator = response -> {
            if (response != null && response.whatIfForecasts() != null) {
                return response.whatIfForecasts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWhatIfForecastsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWhatIfForecastsResponseFetcher
    implements AsyncPageFetcher<ListWhatIfForecastsResponse> {
        private ListWhatIfForecastsResponseFetcher() {
        }

        public boolean hasNextPage(ListWhatIfForecastsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWhatIfForecastsResponse> nextPage(ListWhatIfForecastsResponse previousPage) {
            if (previousPage == null) {
                return ListWhatIfForecastsPublisher.this.client.listWhatIfForecasts(ListWhatIfForecastsPublisher.this.firstRequest);
            }
            return ListWhatIfForecastsPublisher.this.client.listWhatIfForecasts((ListWhatIfForecastsRequest)((Object)ListWhatIfForecastsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

