/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an integer hyperparameter and it's range of tunable values. This object is part of the
 * <a>ParameterRanges</a> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegerParameterRange implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegerParameterRange.Builder, IntegerParameterRange> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(IntegerParameterRange::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> MAX_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxValue").getter(getter(IntegerParameterRange::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()).build();

    private static final SdkField<Integer> MIN_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinValue").getter(getter(IntegerParameterRange::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()).build();

    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingType").getter(getter(IntegerParameterRange::scalingTypeAsString))
            .setter(setter(Builder::scalingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAX_VALUE_FIELD,
            MIN_VALUE_FIELD, SCALING_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer maxValue;

    private final Integer minValue;

    private final String scalingType;

    private IntegerParameterRange(BuilderImpl builder) {
        this.name = builder.name;
        this.maxValue = builder.maxValue;
        this.minValue = builder.minValue;
        this.scalingType = builder.scalingType;
    }

    /**
     * <p>
     * The name of the hyperparameter to tune.
     * </p>
     * 
     * @return The name of the hyperparameter to tune.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The maximum tunable value of the hyperparameter.
     * </p>
     * 
     * @return The maximum tunable value of the hyperparameter.
     */
    public final Integer maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * The minimum tunable value of the hyperparameter.
     * </p>
     * 
     * @return The minimum tunable value of the hyperparameter.
     */
    public final Integer minValue() {
        return minValue;
    }

    /**
     * <p>
     * The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:
     * </p>
     * <dl>
     * <dt>Auto</dt>
     * <dd>
     * <p>
     * Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
     * </p>
     * </dd>
     * <dt>Linear</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     * </p>
     * </dd>
     * <dt>Logarithmic</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     * </p>
     * <p>
     * Logarithmic scaling works only for ranges that have values greater than 0.
     * </p>
     * </dd>
     * <dt>ReverseLogarithmic</dt>
     * <dd>
     * <p>
     * Not supported for <code>IntegerParameterRange</code>.
     * </p>
     * <p>
     * Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For information about choosing a hyperparameter scale, see <a
     * href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
     * >Hyperparameter Scaling</a>. One of the following values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link ScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
     *         <dl>
     *         <dt>Auto</dt>
     *         <dd>
     *         <p>
     *         Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
     *         </p>
     *         </dd>
     *         <dt>Linear</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     *         </p>
     *         </dd>
     *         <dt>Logarithmic</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     *         </p>
     *         <p>
     *         Logarithmic scaling works only for ranges that have values greater than 0.
     *         </p>
     *         </dd>
     *         <dt>ReverseLogarithmic</dt>
     *         <dd>
     *         <p>
     *         Not supported for <code>IntegerParameterRange</code>.
     *         </p>
     *         <p>
     *         Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         For information about choosing a hyperparameter scale, see <a href=
     *         "http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
     *         >Hyperparameter Scaling</a>. One of the following values:
     * @see ScalingType
     */
    public final ScalingType scalingType() {
        return ScalingType.fromValue(scalingType);
    }

    /**
     * <p>
     * The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:
     * </p>
     * <dl>
     * <dt>Auto</dt>
     * <dd>
     * <p>
     * Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
     * </p>
     * </dd>
     * <dt>Linear</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     * </p>
     * </dd>
     * <dt>Logarithmic</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     * </p>
     * <p>
     * Logarithmic scaling works only for ranges that have values greater than 0.
     * </p>
     * </dd>
     * <dt>ReverseLogarithmic</dt>
     * <dd>
     * <p>
     * Not supported for <code>IntegerParameterRange</code>.
     * </p>
     * <p>
     * Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For information about choosing a hyperparameter scale, see <a
     * href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
     * >Hyperparameter Scaling</a>. One of the following values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link ScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
     *         <dl>
     *         <dt>Auto</dt>
     *         <dd>
     *         <p>
     *         Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
     *         </p>
     *         </dd>
     *         <dt>Linear</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     *         </p>
     *         </dd>
     *         <dt>Logarithmic</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     *         </p>
     *         <p>
     *         Logarithmic scaling works only for ranges that have values greater than 0.
     *         </p>
     *         </dd>
     *         <dt>ReverseLogarithmic</dt>
     *         <dd>
     *         <p>
     *         Not supported for <code>IntegerParameterRange</code>.
     *         </p>
     *         <p>
     *         Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         For information about choosing a hyperparameter scale, see <a href=
     *         "http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
     *         >Hyperparameter Scaling</a>. One of the following values:
     * @see ScalingType
     */
    public final String scalingTypeAsString() {
        return scalingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(scalingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerParameterRange)) {
            return false;
        }
        IntegerParameterRange other = (IntegerParameterRange) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(maxValue(), other.maxValue())
                && Objects.equals(minValue(), other.minValue())
                && Objects.equals(scalingTypeAsString(), other.scalingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegerParameterRange").add("Name", name()).add("MaxValue", maxValue())
                .add("MinValue", minValue()).add("ScalingType", scalingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "ScalingType":
            return Optional.ofNullable(clazz.cast(scalingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntegerParameterRange, T> g) {
        return obj -> g.apply((IntegerParameterRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegerParameterRange> {
        /**
         * <p>
         * The name of the hyperparameter to tune.
         * </p>
         * 
         * @param name
         *        The name of the hyperparameter to tune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The maximum tunable value of the hyperparameter.
         * </p>
         * 
         * @param maxValue
         *        The maximum tunable value of the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Integer maxValue);

        /**
         * <p>
         * The minimum tunable value of the hyperparameter.
         * </p>
         * 
         * @param minValue
         *        The minimum tunable value of the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Integer minValue);

        /**
         * <p>
         * The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:
         * </p>
         * <dl>
         * <dt>Auto</dt>
         * <dd>
         * <p>
         * Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
         * </p>
         * </dd>
         * <dt>Linear</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         * </p>
         * </dd>
         * <dt>Logarithmic</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         * </p>
         * <p>
         * Logarithmic scaling works only for ranges that have values greater than 0.
         * </p>
         * </dd>
         * <dt>ReverseLogarithmic</dt>
         * <dd>
         * <p>
         * Not supported for <code>IntegerParameterRange</code>.
         * </p>
         * <p>
         * Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * For information about choosing a hyperparameter scale, see <a href=
         * "http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
         * >Hyperparameter Scaling</a>. One of the following values:
         * </p>
         * 
         * @param scalingType
         *        The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
         *        <dl>
         *        <dt>Auto</dt>
         *        <dd>
         *        <p>
         *        Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
         *        </p>
         *        </dd>
         *        <dt>Linear</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         *        </p>
         *        </dd>
         *        <dt>Logarithmic</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         *        </p>
         *        <p>
         *        Logarithmic scaling works only for ranges that have values greater than 0.
         *        </p>
         *        </dd>
         *        <dt>ReverseLogarithmic</dt>
         *        <dd>
         *        <p>
         *        Not supported for <code>IntegerParameterRange</code>.
         *        </p>
         *        <p>
         *        Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt;
         *        1.0.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        For information about choosing a hyperparameter scale, see <a href=
         *        "http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
         *        >Hyperparameter Scaling</a>. One of the following values:
         * @see ScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingType
         */
        Builder scalingType(String scalingType);

        /**
         * <p>
         * The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:
         * </p>
         * <dl>
         * <dt>Auto</dt>
         * <dd>
         * <p>
         * Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
         * </p>
         * </dd>
         * <dt>Linear</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         * </p>
         * </dd>
         * <dt>Logarithmic</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         * </p>
         * <p>
         * Logarithmic scaling works only for ranges that have values greater than 0.
         * </p>
         * </dd>
         * <dt>ReverseLogarithmic</dt>
         * <dd>
         * <p>
         * Not supported for <code>IntegerParameterRange</code>.
         * </p>
         * <p>
         * Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * For information about choosing a hyperparameter scale, see <a href=
         * "http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
         * >Hyperparameter Scaling</a>. One of the following values:
         * </p>
         * 
         * @param scalingType
         *        The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p>
         *        <dl>
         *        <dt>Auto</dt>
         *        <dd>
         *        <p>
         *        Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
         *        </p>
         *        </dd>
         *        <dt>Linear</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         *        </p>
         *        </dd>
         *        <dt>Logarithmic</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         *        </p>
         *        <p>
         *        Logarithmic scaling works only for ranges that have values greater than 0.
         *        </p>
         *        </dd>
         *        <dt>ReverseLogarithmic</dt>
         *        <dd>
         *        <p>
         *        Not supported for <code>IntegerParameterRange</code>.
         *        </p>
         *        <p>
         *        Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt;
         *        1.0.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        For information about choosing a hyperparameter scale, see <a href=
         *        "http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
         *        >Hyperparameter Scaling</a>. One of the following values:
         * @see ScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingType
         */
        Builder scalingType(ScalingType scalingType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer maxValue;

        private Integer minValue;

        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerParameterRange model) {
            name(model.name);
            maxValue(model.maxValue);
            minValue(model.minValue);
            scalingType(model.scalingType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final Integer getMinValue() {
            return minValue;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final String getScalingType() {
            return scalingType;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(ScalingType scalingType) {
            this.scalingType(scalingType == null ? null : scalingType.toString());
            return this;
        }

        @Override
        public IntegerParameterRange build() {
            return new IntegerParameterRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
