/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the route endpoint that violates the policy scope.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteHasOutOfScopeEndpointViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteHasOutOfScopeEndpointViolation.Builder, RouteHasOutOfScopeEndpointViolation> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(RouteHasOutOfScopeEndpointViolation::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(RouteHasOutOfScopeEndpointViolation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId").getter(getter(RouteHasOutOfScopeEndpointViolation::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final SdkField<List<Route>> VIOLATING_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("ViolatingRoutes")
            .getter(getter(RouteHasOutOfScopeEndpointViolation::violatingRoutes))
            .setter(setter(Builder::violatingRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetAvailabilityZone").getter(getter(RouteHasOutOfScopeEndpointViolation::subnetAvailabilityZone))
            .setter(setter(Builder::subnetAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build())
            .build();

    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetAvailabilityZoneId").getter(getter(RouteHasOutOfScopeEndpointViolation::subnetAvailabilityZoneId))
            .setter(setter(Builder::subnetAvailabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZoneId").build())
            .build();

    private static final SdkField<String> CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentFirewallSubnetRouteTable")
            .getter(getter(RouteHasOutOfScopeEndpointViolation::currentFirewallSubnetRouteTable))
            .setter(setter(Builder::currentFirewallSubnetRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFirewallSubnetRouteTable")
                    .build()).build();

    private static final SdkField<String> FIREWALL_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallSubnetId").getter(getter(RouteHasOutOfScopeEndpointViolation::firewallSubnetId))
            .setter(setter(Builder::firewallSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetId").build()).build();

    private static final SdkField<List<Route>> FIREWALL_SUBNET_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("FirewallSubnetRoutes")
            .getter(getter(RouteHasOutOfScopeEndpointViolation::firewallSubnetRoutes))
            .setter(setter(Builder::firewallSubnetRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INTERNET_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InternetGatewayId").getter(getter(RouteHasOutOfScopeEndpointViolation::internetGatewayId))
            .setter(setter(Builder::internetGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayId").build()).build();

    private static final SdkField<String> CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentInternetGatewayRouteTable")
            .getter(getter(RouteHasOutOfScopeEndpointViolation::currentInternetGatewayRouteTable))
            .setter(setter(Builder::currentInternetGatewayRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInternetGatewayRouteTable")
                    .build()).build();

    private static final SdkField<List<Route>> INTERNET_GATEWAY_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("InternetGatewayRoutes")
            .getter(getter(RouteHasOutOfScopeEndpointViolation::internetGatewayRoutes))
            .setter(setter(Builder::internetGatewayRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, VPC_ID_FIELD,
            ROUTE_TABLE_ID_FIELD, VIOLATING_ROUTES_FIELD, SUBNET_AVAILABILITY_ZONE_FIELD, SUBNET_AVAILABILITY_ZONE_ID_FIELD,
            CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD, FIREWALL_SUBNET_ID_FIELD, FIREWALL_SUBNET_ROUTES_FIELD,
            INTERNET_GATEWAY_ID_FIELD, CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD, INTERNET_GATEWAY_ROUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subnetId;

    private final String vpcId;

    private final String routeTableId;

    private final List<Route> violatingRoutes;

    private final String subnetAvailabilityZone;

    private final String subnetAvailabilityZoneId;

    private final String currentFirewallSubnetRouteTable;

    private final String firewallSubnetId;

    private final List<Route> firewallSubnetRoutes;

    private final String internetGatewayId;

    private final String currentInternetGatewayRouteTable;

    private final List<Route> internetGatewayRoutes;

    private RouteHasOutOfScopeEndpointViolation(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.routeTableId = builder.routeTableId;
        this.violatingRoutes = builder.violatingRoutes;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.subnetAvailabilityZoneId = builder.subnetAvailabilityZoneId;
        this.currentFirewallSubnetRouteTable = builder.currentFirewallSubnetRouteTable;
        this.firewallSubnetId = builder.firewallSubnetId;
        this.firewallSubnetRoutes = builder.firewallSubnetRoutes;
        this.internetGatewayId = builder.internetGatewayId;
        this.currentInternetGatewayRouteTable = builder.currentInternetGatewayRouteTable;
        this.internetGatewayRoutes = builder.internetGatewayRoutes;
    }

    /**
     * <p>
     * The ID of the subnet associated with the route that violates the policy scope.
     * </p>
     * 
     * @return The ID of the subnet associated with the route that violates the policy scope.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The VPC ID of the route that violates the policy scope.
     * </p>
     * 
     * @return The VPC ID of the route that violates the policy scope.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViolatingRoutes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasViolatingRoutes() {
        return violatingRoutes != null && !(violatingRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of routes that violate the route table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViolatingRoutes} method.
     * </p>
     * 
     * @return The list of routes that violate the route table.
     */
    public final List<Route> violatingRoutes() {
        return violatingRoutes;
    }

    /**
     * <p>
     * The subnet's Availability Zone.
     * </p>
     * 
     * @return The subnet's Availability Zone.
     */
    public final String subnetAvailabilityZone() {
        return subnetAvailabilityZone;
    }

    /**
     * <p>
     * The ID of the subnet's Availability Zone.
     * </p>
     * 
     * @return The ID of the subnet's Availability Zone.
     */
    public final String subnetAvailabilityZoneId() {
        return subnetAvailabilityZoneId;
    }

    /**
     * <p>
     * The route table associated with the current firewall subnet.
     * </p>
     * 
     * @return The route table associated with the current firewall subnet.
     */
    public final String currentFirewallSubnetRouteTable() {
        return currentFirewallSubnetRouteTable;
    }

    /**
     * <p>
     * The ID of the firewall subnet.
     * </p>
     * 
     * @return The ID of the firewall subnet.
     */
    public final String firewallSubnetId() {
        return firewallSubnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FirewallSubnetRoutes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFirewallSubnetRoutes() {
        return firewallSubnetRoutes != null && !(firewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of firewall subnet routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFirewallSubnetRoutes} method.
     * </p>
     * 
     * @return The list of firewall subnet routes.
     */
    public final List<Route> firewallSubnetRoutes() {
        return firewallSubnetRoutes;
    }

    /**
     * <p>
     * The ID of the Internet Gateway.
     * </p>
     * 
     * @return The ID of the Internet Gateway.
     */
    public final String internetGatewayId() {
        return internetGatewayId;
    }

    /**
     * <p>
     * The current route table associated with the Internet Gateway.
     * </p>
     * 
     * @return The current route table associated with the Internet Gateway.
     */
    public final String currentInternetGatewayRouteTable() {
        return currentInternetGatewayRouteTable;
    }

    /**
     * For responses, this returns true if the service returned a value for the InternetGatewayRoutes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInternetGatewayRoutes() {
        return internetGatewayRoutes != null && !(internetGatewayRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routes in the route table associated with the Internet Gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInternetGatewayRoutes} method.
     * </p>
     * 
     * @return The routes in the route table associated with the Internet Gateway.
     */
    public final List<Route> internetGatewayRoutes() {
        return internetGatewayRoutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(hasViolatingRoutes() ? violatingRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(subnetAvailabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(currentFirewallSubnetRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(firewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFirewallSubnetRoutes() ? firewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(currentInternetGatewayRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(hasInternetGatewayRoutes() ? internetGatewayRoutes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteHasOutOfScopeEndpointViolation)) {
            return false;
        }
        RouteHasOutOfScopeEndpointViolation other = (RouteHasOutOfScopeEndpointViolation) obj;
        return Objects.equals(subnetId(), other.subnetId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(routeTableId(), other.routeTableId()) && hasViolatingRoutes() == other.hasViolatingRoutes()
                && Objects.equals(violatingRoutes(), other.violatingRoutes())
                && Objects.equals(subnetAvailabilityZone(), other.subnetAvailabilityZone())
                && Objects.equals(subnetAvailabilityZoneId(), other.subnetAvailabilityZoneId())
                && Objects.equals(currentFirewallSubnetRouteTable(), other.currentFirewallSubnetRouteTable())
                && Objects.equals(firewallSubnetId(), other.firewallSubnetId())
                && hasFirewallSubnetRoutes() == other.hasFirewallSubnetRoutes()
                && Objects.equals(firewallSubnetRoutes(), other.firewallSubnetRoutes())
                && Objects.equals(internetGatewayId(), other.internetGatewayId())
                && Objects.equals(currentInternetGatewayRouteTable(), other.currentInternetGatewayRouteTable())
                && hasInternetGatewayRoutes() == other.hasInternetGatewayRoutes()
                && Objects.equals(internetGatewayRoutes(), other.internetGatewayRoutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteHasOutOfScopeEndpointViolation").add("SubnetId", subnetId()).add("VpcId", vpcId())
                .add("RouteTableId", routeTableId()).add("ViolatingRoutes", hasViolatingRoutes() ? violatingRoutes() : null)
                .add("SubnetAvailabilityZone", subnetAvailabilityZone())
                .add("SubnetAvailabilityZoneId", subnetAvailabilityZoneId())
                .add("CurrentFirewallSubnetRouteTable", currentFirewallSubnetRouteTable())
                .add("FirewallSubnetId", firewallSubnetId())
                .add("FirewallSubnetRoutes", hasFirewallSubnetRoutes() ? firewallSubnetRoutes() : null)
                .add("InternetGatewayId", internetGatewayId())
                .add("CurrentInternetGatewayRouteTable", currentInternetGatewayRouteTable())
                .add("InternetGatewayRoutes", hasInternetGatewayRoutes() ? internetGatewayRoutes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "ViolatingRoutes":
            return Optional.ofNullable(clazz.cast(violatingRoutes()));
        case "SubnetAvailabilityZone":
            return Optional.ofNullable(clazz.cast(subnetAvailabilityZone()));
        case "SubnetAvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(subnetAvailabilityZoneId()));
        case "CurrentFirewallSubnetRouteTable":
            return Optional.ofNullable(clazz.cast(currentFirewallSubnetRouteTable()));
        case "FirewallSubnetId":
            return Optional.ofNullable(clazz.cast(firewallSubnetId()));
        case "FirewallSubnetRoutes":
            return Optional.ofNullable(clazz.cast(firewallSubnetRoutes()));
        case "InternetGatewayId":
            return Optional.ofNullable(clazz.cast(internetGatewayId()));
        case "CurrentInternetGatewayRouteTable":
            return Optional.ofNullable(clazz.cast(currentInternetGatewayRouteTable()));
        case "InternetGatewayRoutes":
            return Optional.ofNullable(clazz.cast(internetGatewayRoutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteHasOutOfScopeEndpointViolation, T> g) {
        return obj -> g.apply((RouteHasOutOfScopeEndpointViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteHasOutOfScopeEndpointViolation> {
        /**
         * <p>
         * The ID of the subnet associated with the route that violates the policy scope.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet associated with the route that violates the policy scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The VPC ID of the route that violates the policy scope.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID of the route that violates the policy scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The list of routes that violate the route table.
         * </p>
         * 
         * @param violatingRoutes
         *        The list of routes that violate the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingRoutes(Collection<Route> violatingRoutes);

        /**
         * <p>
         * The list of routes that violate the route table.
         * </p>
         * 
         * @param violatingRoutes
         *        The list of routes that violate the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingRoutes(Route... violatingRoutes);

        /**
         * <p>
         * The list of routes that violate the route table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.Route.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fms.model.Route.Builder#build()}
         * is called immediately and its result is passed to {@link #violatingRoutes(List<Route>)}.
         * 
         * @param violatingRoutes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fms.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violatingRoutes(java.util.Collection<Route>)
         */
        Builder violatingRoutes(Consumer<Route.Builder>... violatingRoutes);

        /**
         * <p>
         * The subnet's Availability Zone.
         * </p>
         * 
         * @param subnetAvailabilityZone
         *        The subnet's Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetAvailabilityZone(String subnetAvailabilityZone);

        /**
         * <p>
         * The ID of the subnet's Availability Zone.
         * </p>
         * 
         * @param subnetAvailabilityZoneId
         *        The ID of the subnet's Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetAvailabilityZoneId(String subnetAvailabilityZoneId);

        /**
         * <p>
         * The route table associated with the current firewall subnet.
         * </p>
         * 
         * @param currentFirewallSubnetRouteTable
         *        The route table associated with the current firewall subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable);

        /**
         * <p>
         * The ID of the firewall subnet.
         * </p>
         * 
         * @param firewallSubnetId
         *        The ID of the firewall subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallSubnetId(String firewallSubnetId);

        /**
         * <p>
         * The list of firewall subnet routes.
         * </p>
         * 
         * @param firewallSubnetRoutes
         *        The list of firewall subnet routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallSubnetRoutes(Collection<Route> firewallSubnetRoutes);

        /**
         * <p>
         * The list of firewall subnet routes.
         * </p>
         * 
         * @param firewallSubnetRoutes
         *        The list of firewall subnet routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallSubnetRoutes(Route... firewallSubnetRoutes);

        /**
         * <p>
         * The list of firewall subnet routes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.Route.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fms.model.Route.Builder#build()}
         * is called immediately and its result is passed to {@link #firewallSubnetRoutes(List<Route>)}.
         * 
         * @param firewallSubnetRoutes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fms.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallSubnetRoutes(java.util.Collection<Route>)
         */
        Builder firewallSubnetRoutes(Consumer<Route.Builder>... firewallSubnetRoutes);

        /**
         * <p>
         * The ID of the Internet Gateway.
         * </p>
         * 
         * @param internetGatewayId
         *        The ID of the Internet Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGatewayId(String internetGatewayId);

        /**
         * <p>
         * The current route table associated with the Internet Gateway.
         * </p>
         * 
         * @param currentInternetGatewayRouteTable
         *        The current route table associated with the Internet Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentInternetGatewayRouteTable(String currentInternetGatewayRouteTable);

        /**
         * <p>
         * The routes in the route table associated with the Internet Gateway.
         * </p>
         * 
         * @param internetGatewayRoutes
         *        The routes in the route table associated with the Internet Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGatewayRoutes(Collection<Route> internetGatewayRoutes);

        /**
         * <p>
         * The routes in the route table associated with the Internet Gateway.
         * </p>
         * 
         * @param internetGatewayRoutes
         *        The routes in the route table associated with the Internet Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGatewayRoutes(Route... internetGatewayRoutes);

        /**
         * <p>
         * The routes in the route table associated with the Internet Gateway.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.Route.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fms.model.Route.Builder#build()}
         * is called immediately and its result is passed to {@link #internetGatewayRoutes(List<Route>)}.
         * 
         * @param internetGatewayRoutes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fms.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internetGatewayRoutes(java.util.Collection<Route>)
         */
        Builder internetGatewayRoutes(Consumer<Route.Builder>... internetGatewayRoutes);
    }

    static final class BuilderImpl implements Builder {
        private String subnetId;

        private String vpcId;

        private String routeTableId;

        private List<Route> violatingRoutes = DefaultSdkAutoConstructList.getInstance();

        private String subnetAvailabilityZone;

        private String subnetAvailabilityZoneId;

        private String currentFirewallSubnetRouteTable;

        private String firewallSubnetId;

        private List<Route> firewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();

        private String internetGatewayId;

        private String currentInternetGatewayRouteTable;

        private List<Route> internetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteHasOutOfScopeEndpointViolation model) {
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            routeTableId(model.routeTableId);
            violatingRoutes(model.violatingRoutes);
            subnetAvailabilityZone(model.subnetAvailabilityZone);
            subnetAvailabilityZoneId(model.subnetAvailabilityZoneId);
            currentFirewallSubnetRouteTable(model.currentFirewallSubnetRouteTable);
            firewallSubnetId(model.firewallSubnetId);
            firewallSubnetRoutes(model.firewallSubnetRoutes);
            internetGatewayId(model.internetGatewayId);
            currentInternetGatewayRouteTable(model.currentInternetGatewayRouteTable);
            internetGatewayRoutes(model.internetGatewayRoutes);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final List<Route.Builder> getViolatingRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.violatingRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatingRoutes(Collection<Route.BuilderImpl> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copyFromBuilder(violatingRoutes);
        }

        @Override
        public final Builder violatingRoutes(Collection<Route> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copy(violatingRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Route... violatingRoutes) {
            violatingRoutes(Arrays.asList(violatingRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Consumer<Route.Builder>... violatingRoutes) {
            violatingRoutes(Stream.of(violatingRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSubnetAvailabilityZone() {
            return subnetAvailabilityZone;
        }

        public final void setSubnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
        }

        @Override
        public final Builder subnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final String getSubnetAvailabilityZoneId() {
            return subnetAvailabilityZoneId;
        }

        public final void setSubnetAvailabilityZoneId(String subnetAvailabilityZoneId) {
            this.subnetAvailabilityZoneId = subnetAvailabilityZoneId;
        }

        @Override
        public final Builder subnetAvailabilityZoneId(String subnetAvailabilityZoneId) {
            this.subnetAvailabilityZoneId = subnetAvailabilityZoneId;
            return this;
        }

        public final String getCurrentFirewallSubnetRouteTable() {
            return currentFirewallSubnetRouteTable;
        }

        public final void setCurrentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
        }

        @Override
        public final Builder currentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
            return this;
        }

        public final String getFirewallSubnetId() {
            return firewallSubnetId;
        }

        public final void setFirewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
        }

        @Override
        public final Builder firewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
            return this;
        }

        public final List<Route.Builder> getFirewallSubnetRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.firewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallSubnetRoutes(Collection<Route.BuilderImpl> firewallSubnetRoutes) {
            this.firewallSubnetRoutes = RoutesCopier.copyFromBuilder(firewallSubnetRoutes);
        }

        @Override
        public final Builder firewallSubnetRoutes(Collection<Route> firewallSubnetRoutes) {
            this.firewallSubnetRoutes = RoutesCopier.copy(firewallSubnetRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallSubnetRoutes(Route... firewallSubnetRoutes) {
            firewallSubnetRoutes(Arrays.asList(firewallSubnetRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallSubnetRoutes(Consumer<Route.Builder>... firewallSubnetRoutes) {
            firewallSubnetRoutes(Stream.of(firewallSubnetRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInternetGatewayId() {
            return internetGatewayId;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final String getCurrentInternetGatewayRouteTable() {
            return currentInternetGatewayRouteTable;
        }

        public final void setCurrentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
        }

        @Override
        public final Builder currentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
            return this;
        }

        public final List<Route.Builder> getInternetGatewayRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.internetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInternetGatewayRoutes(Collection<Route.BuilderImpl> internetGatewayRoutes) {
            this.internetGatewayRoutes = RoutesCopier.copyFromBuilder(internetGatewayRoutes);
        }

        @Override
        public final Builder internetGatewayRoutes(Collection<Route> internetGatewayRoutes) {
            this.internetGatewayRoutes = RoutesCopier.copy(internetGatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGatewayRoutes(Route... internetGatewayRoutes) {
            internetGatewayRoutes(Arrays.asList(internetGatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGatewayRoutes(Consumer<Route.Builder>... internetGatewayRoutes) {
            internetGatewayRoutes(Stream.of(internetGatewayRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RouteHasOutOfScopeEndpointViolation build() {
            return new RouteHasOutOfScopeEndpointViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
