/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppsListsResponse extends FmsResponse implements
        ToCopyableBuilder<ListAppsListsResponse.Builder, ListAppsListsResponse> {
    private static final SdkField<List<AppsListDataSummary>> APPS_LISTS_FIELD = SdkField
            .<List<AppsListDataSummary>> builder(MarshallingType.LIST)
            .memberName("AppsLists")
            .getter(getter(ListAppsListsResponse::appsLists))
            .setter(setter(Builder::appsLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsLists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppsListDataSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppsListDataSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAppsListsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_LISTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AppsListDataSummary> appsLists;

    private final String nextToken;

    private ListAppsListsResponse(BuilderImpl builder) {
        super(builder);
        this.appsLists = builder.appsLists;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppsLists property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAppsLists() {
        return appsLists != null && !(appsLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>AppsListDataSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppsLists} method.
     * </p>
     * 
     * @return An array of <code>AppsListDataSummary</code> objects.
     */
    public final List<AppsListDataSummary> appsLists() {
        return appsLists;
    }

    /**
     * <p>
     * If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the
     * maximum, Firewall Manager returns this token in the response. You can use this token in subsequent requests to
     * retrieve the next batch of objects.
     * </p>
     * 
     * @return If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than
     *         the maximum, Firewall Manager returns this token in the response. You can use this token in subsequent
     *         requests to retrieve the next batch of objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAppsLists() ? appsLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsListsResponse)) {
            return false;
        }
        ListAppsListsResponse other = (ListAppsListsResponse) obj;
        return hasAppsLists() == other.hasAppsLists() && Objects.equals(appsLists(), other.appsLists())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppsListsResponse").add("AppsLists", hasAppsLists() ? appsLists() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppsLists":
            return Optional.ofNullable(clazz.cast(appsLists()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppsListsResponse, T> g) {
        return obj -> g.apply((ListAppsListsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppsListsResponse> {
        /**
         * <p>
         * An array of <code>AppsListDataSummary</code> objects.
         * </p>
         * 
         * @param appsLists
         *        An array of <code>AppsListDataSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsLists(Collection<AppsListDataSummary> appsLists);

        /**
         * <p>
         * An array of <code>AppsListDataSummary</code> objects.
         * </p>
         * 
         * @param appsLists
         *        An array of <code>AppsListDataSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsLists(AppsListDataSummary... appsLists);

        /**
         * <p>
         * An array of <code>AppsListDataSummary</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.AppsListDataSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.fms.model.AppsListDataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fms.model.AppsListDataSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #appsLists(List<AppsListDataSummary>)}.
         * 
         * @param appsLists
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fms.model.AppsListDataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appsLists(java.util.Collection<AppsListDataSummary>)
         */
        Builder appsLists(Consumer<AppsListDataSummary.Builder>... appsLists);

        /**
         * <p>
         * If you specify a value for <code>MaxResults</code> in your list request, and you have more objects than the
         * maximum, Firewall Manager returns this token in the response. You can use this token in subsequent requests
         * to retrieve the next batch of objects.
         * </p>
         * 
         * @param nextToken
         *        If you specify a value for <code>MaxResults</code> in your list request, and you have more objects
         *        than the maximum, Firewall Manager returns this token in the response. You can use this token in
         *        subsequent requests to retrieve the next batch of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private List<AppsListDataSummary> appsLists = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsListsResponse model) {
            super(model);
            appsLists(model.appsLists);
            nextToken(model.nextToken);
        }

        public final List<AppsListDataSummary.Builder> getAppsLists() {
            List<AppsListDataSummary.Builder> result = AppsListsDataCopier.copyToBuilder(this.appsLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppsLists(Collection<AppsListDataSummary.BuilderImpl> appsLists) {
            this.appsLists = AppsListsDataCopier.copyFromBuilder(appsLists);
        }

        @Override
        public final Builder appsLists(Collection<AppsListDataSummary> appsLists) {
            this.appsLists = AppsListsDataCopier.copy(appsLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsLists(AppsListDataSummary... appsLists) {
            appsLists(Arrays.asList(appsLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsLists(Consumer<AppsListDataSummary.Builder>... appsLists) {
            appsLists(Stream.of(appsLists).map(c -> AppsListDataSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppsListsResponse build() {
            return new ListAppsListsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
