/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a Kinesis data stream used as the source for a Kinesis Data Firehose delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceDescription.Builder, SourceDescription> {
    private static final SdkField<KinesisStreamSourceDescription> KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD = SdkField
            .<KinesisStreamSourceDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(SourceDescription::kinesisStreamSourceDescription))
            .setter(setter(Builder::kinesisStreamSourceDescription))
            .constructor(KinesisStreamSourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamSourceDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final KinesisStreamSourceDescription kinesisStreamSourceDescription;

    private SourceDescription(BuilderImpl builder) {
        this.kinesisStreamSourceDescription = builder.kinesisStreamSourceDescription;
    }

    /**
     * <p>
     * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
     * </p>
     * 
     * @return The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
     */
    public KinesisStreamSourceDescription kinesisStreamSourceDescription() {
        return kinesisStreamSourceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamSourceDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDescription)) {
            return false;
        }
        SourceDescription other = (SourceDescription) obj;
        return Objects.equals(kinesisStreamSourceDescription(), other.kinesisStreamSourceDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SourceDescription").add("KinesisStreamSourceDescription", kinesisStreamSourceDescription())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisStreamSourceDescription":
            return Optional.ofNullable(clazz.cast(kinesisStreamSourceDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceDescription, T> g) {
        return obj -> g.apply((SourceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDescription> {
        /**
         * <p>
         * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
         * </p>
         * 
         * @param kinesisStreamSourceDescription
         *        The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription kinesisStreamSourceDescription);

        /**
         * <p>
         * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamSourceDescription.Builder} avoiding
         * the need to create one manually via {@link KinesisStreamSourceDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamSourceDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisStreamSourceDescription(KinesisStreamSourceDescription)}.
         * 
         * @param kinesisStreamSourceDescription
         *        a consumer that will call methods on {@link KinesisStreamSourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamSourceDescription(KinesisStreamSourceDescription)
         */
        default Builder kinesisStreamSourceDescription(
                Consumer<KinesisStreamSourceDescription.Builder> kinesisStreamSourceDescription) {
            return kinesisStreamSourceDescription(KinesisStreamSourceDescription.builder()
                    .applyMutation(kinesisStreamSourceDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KinesisStreamSourceDescription kinesisStreamSourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDescription model) {
            kinesisStreamSourceDescription(model.kinesisStreamSourceDescription);
        }

        public final KinesisStreamSourceDescription.Builder getKinesisStreamSourceDescription() {
            return kinesisStreamSourceDescription != null ? kinesisStreamSourceDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription;
            return this;
        }

        public final void setKinesisStreamSourceDescription(
                KinesisStreamSourceDescription.BuilderImpl kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription != null ? kinesisStreamSourceDescription.build()
                    : null;
        }

        @Override
        public SourceDescription build() {
            return new SourceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
