/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a destination in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3DestinationConfiguration.Builder, S3DestinationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3DestinationConfiguration::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3DestinationConfiguration::bucketARN)).setter(setter(Builder::bucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3DestinationConfiguration::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> ERROR_OUTPUT_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3DestinationConfiguration::errorOutputPrefix)).setter(setter(Builder::errorOutputPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorOutputPrefix").build()).build();

    private static final SdkField<BufferingHints> BUFFERING_HINTS_FIELD = SdkField
            .<BufferingHints> builder(MarshallingType.SDK_POJO).getter(getter(S3DestinationConfiguration::bufferingHints))
            .setter(setter(Builder::bufferingHints)).constructor(BufferingHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()).build();

    private static final SdkField<String> COMPRESSION_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3DestinationConfiguration::compressionFormatAsString)).setter(setter(Builder::compressionFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionFormat").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(S3DestinationConfiguration::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<CloudWatchLoggingOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(S3DestinationConfiguration::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            BUCKET_ARN_FIELD, PREFIX_FIELD, ERROR_OUTPUT_PREFIX_FIELD, BUFFERING_HINTS_FIELD, COMPRESSION_FORMAT_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleARN;

    private final String bucketARN;

    private final String prefix;

    private final String errorOutputPrefix;

    private final BufferingHints bufferingHints;

    private final String compressionFormat;

    private final EncryptionConfiguration encryptionConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private S3DestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.errorOutputPrefix = builder.errorOutputPrefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and AWS Service Namespaces</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and AWS Service Namespaces</a>.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and AWS Service Namespaces</a>.
     * </p>
     * 
     * @return The ARN of the S3 bucket. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and AWS Service Namespaces</a>.
     */
    public String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can specify an
     * extra prefix to be added in front of the time format prefix. If the prefix ends with a slash, it appears as a
     * folder in the S3 bucket. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#s3-object-name">Amazon S3 Object Name
     * Format</a> in the <i>Amazon Kinesis Data Firehose Developer Guide</i>.
     * </p>
     * 
     * @return The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can
     *         specify an extra prefix to be added in front of the time format prefix. If the prefix ends with a slash,
     *         it appears as a folder in the S3 bucket. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#s3-object-name">Amazon S3 Object
     *         Name Format</a> in the <i>Amazon Kinesis Data Firehose Developer Guide</i>.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix
     * appears immediately following the bucket name.
     * </p>
     * 
     * @return A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This
     *         prefix appears immediately following the bucket name.
     */
    public String errorOutputPrefix() {
        return errorOutputPrefix;
    }

    /**
     * <p>
     * The buffering option. If no value is specified, <code>BufferingHints</code> object default values are used.
     * </p>
     * 
     * @return The buffering option. If no value is specified, <code>BufferingHints</code> object default values are
     *         used.
     */
    public BufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
     * </p>
     * <p>
     * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
     * destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads from
     * the S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionFormat}
     * will return {@link CompressionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionFormatAsString}.
     * </p>
     * 
     * @return The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p>
     *         <p>
     *         The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
     *         destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads
     *         from the S3 bucket.
     * @see CompressionFormat
     */
    public CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(compressionFormat);
    }

    /**
     * <p>
     * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
     * </p>
     * <p>
     * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
     * destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads from
     * the S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionFormat}
     * will return {@link CompressionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionFormatAsString}.
     * </p>
     * 
     * @return The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p>
     *         <p>
     *         The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
     *         destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads
     *         from the S3 bucket.
     * @see CompressionFormat
     */
    public String compressionFormatAsString() {
        return compressionFormat;
    }

    /**
     * <p>
     * The encryption configuration. If no value is specified, the default is no encryption.
     * </p>
     * 
     * @return The encryption configuration. If no value is specified, the default is no encryption.
     */
    public EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(errorOutputPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(compressionFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationConfiguration)) {
            return false;
        }
        S3DestinationConfiguration other = (S3DestinationConfiguration) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(bucketARN(), other.bucketARN())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(errorOutputPrefix(), other.errorOutputPrefix())
                && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(compressionFormatAsString(), other.compressionFormatAsString())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3DestinationConfiguration").add("RoleARN", roleARN()).add("BucketARN", bucketARN())
                .add("Prefix", prefix()).add("ErrorOutputPrefix", errorOutputPrefix()).add("BufferingHints", bufferingHints())
                .add("CompressionFormat", compressionFormatAsString()).add("EncryptionConfiguration", encryptionConfiguration())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "BucketARN":
            return Optional.ofNullable(clazz.cast(bucketARN()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "ErrorOutputPrefix":
            return Optional.ofNullable(clazz.cast(errorOutputPrefix()));
        case "BufferingHints":
            return Optional.ofNullable(clazz.cast(bufferingHints()));
        case "CompressionFormat":
            return Optional.ofNullable(clazz.cast(compressionFormatAsString()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationConfiguration, T> g) {
        return obj -> g.apply((S3DestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DestinationConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a>.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the S3 bucket. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a>.
         * </p>
         * 
         * @param bucketARN
         *        The ARN of the S3 bucket. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can specify
         * an extra prefix to be added in front of the time format prefix. If the prefix ends with a slash, it appears
         * as a folder in the S3 bucket. For more information, see <a
         * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#s3-object-name">Amazon S3 Object Name
         * Format</a> in the <i>Amazon Kinesis Data Firehose Developer Guide</i>.
         * </p>
         * 
         * @param prefix
         *        The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can
         *        specify an extra prefix to be added in front of the time format prefix. If the prefix ends with a
         *        slash, it appears as a folder in the S3 bucket. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#s3-object-name">Amazon S3
         *        Object Name Format</a> in the <i>Amazon Kinesis Data Firehose Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This
         * prefix appears immediately following the bucket name.
         * </p>
         * 
         * @param errorOutputPrefix
         *        A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
         *        This prefix appears immediately following the bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorOutputPrefix(String errorOutputPrefix);

        /**
         * <p>
         * The buffering option. If no value is specified, <code>BufferingHints</code> object default values are used.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering option. If no value is specified, <code>BufferingHints</code> object default values are
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(BufferingHints bufferingHints);

        /**
         * <p>
         * The buffering option. If no value is specified, <code>BufferingHints</code> object default values are used.
         * </p>
         * This is a convenience that creates an instance of the {@link BufferingHints.Builder} avoiding the need to
         * create one manually via {@link BufferingHints#builder()}.
         *
         * When the {@link Consumer} completes, {@link BufferingHints.Builder#build()} is called immediately and its
         * result is passed to {@link #bufferingHints(BufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link BufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(BufferingHints)
         */
        default Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return bufferingHints(BufferingHints.builder().applyMutation(bufferingHints).build());
        }

        /**
         * <p>
         * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
         * </p>
         * <p>
         * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
         * destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads
         * from the S3 bucket.
         * </p>
         * 
         * @param compressionFormat
         *        The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p>
         *        <p>
         *        The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon
         *        Redshift destinations because they are not supported by the Amazon Redshift <code>COPY</code>
         *        operation that reads from the S3 bucket.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compressionFormat(String compressionFormat);

        /**
         * <p>
         * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
         * </p>
         * <p>
         * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
         * destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads
         * from the S3 bucket.
         * </p>
         * 
         * @param compressionFormat
         *        The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p>
         *        <p>
         *        The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon
         *        Redshift destinations because they are not supported by the Amazon Redshift <code>COPY</code>
         *        operation that reads from the S3 bucket.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compressionFormat(CompressionFormat compressionFormat);

        /**
         * <p>
         * The encryption configuration. If no value is specified, the default is no encryption.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration. If no value is specified, the default is no encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration. If no value is specified, the default is no encryption.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding the
         * need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOptions.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String bucketARN;

        private String prefix;

        private String errorOutputPrefix;

        private BufferingHints bufferingHints;

        private String compressionFormat;

        private EncryptionConfiguration encryptionConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationConfiguration model) {
            roleARN(model.roleARN);
            bucketARN(model.bucketARN);
            prefix(model.prefix);
            errorOutputPrefix(model.errorOutputPrefix);
            bufferingHints(model.bufferingHints);
            compressionFormat(model.compressionFormat);
            encryptionConfiguration(model.encryptionConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getErrorOutputPrefix() {
            return errorOutputPrefix;
        }

        @Override
        public final Builder errorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
            return this;
        }

        public final void setErrorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final String getCompressionFormatAsString() {
            return compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat.toString());
            return this;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public S3DestinationConfiguration build() {
            return new S3DestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
