/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecordBatchResponse extends FirehoseResponse implements
        ToCopyableBuilder<PutRecordBatchResponse.Builder, PutRecordBatchResponse> {
    private static final SdkField<Integer> FAILED_PUT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutRecordBatchResponse::failedPutCount)).setter(setter(Builder::failedPutCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedPutCount").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutRecordBatchResponse::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<List<PutRecordBatchResponseEntry>> REQUEST_RESPONSES_FIELD = SdkField
            .<List<PutRecordBatchResponseEntry>> builder(MarshallingType.LIST)
            .getter(getter(PutRecordBatchResponse::requestResponses))
            .setter(setter(Builder::requestResponses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestResponses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutRecordBatchResponseEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutRecordBatchResponseEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_PUT_COUNT_FIELD,
            ENCRYPTED_FIELD, REQUEST_RESPONSES_FIELD));

    private final Integer failedPutCount;

    private final Boolean encrypted;

    private final List<PutRecordBatchResponseEntry> requestResponses;

    private PutRecordBatchResponse(BuilderImpl builder) {
        super(builder);
        this.failedPutCount = builder.failedPutCount;
        this.encrypted = builder.encrypted;
        this.requestResponses = builder.requestResponses;
    }

    /**
     * <p>
     * The number of records that might have failed processing. This number might be greater than 0 even if the
     * <a>PutRecordBatch</a> call succeeds. Check <code>FailedPutCount</code> to determine whether there are records
     * that you need to resend.
     * </p>
     * 
     * @return The number of records that might have failed processing. This number might be greater than 0 even if the
     *         <a>PutRecordBatch</a> call succeeds. Check <code>FailedPutCount</code> to determine whether there are
     *         records that you need to resend.
     */
    public Integer failedPutCount() {
        return failedPutCount;
    }

    /**
     * <p>
     * Indicates whether server-side encryption (SSE) was enabled during this operation.
     * </p>
     * 
     * @return Indicates whether server-side encryption (SSE) was enabled during this operation.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The results array. For each record, the index of the response element is the same as the index used in the
     * request array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The results array. For each record, the index of the response element is the same as the index used in
     *         the request array.
     */
    public List<PutRecordBatchResponseEntry> requestResponses() {
        return requestResponses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failedPutCount());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(requestResponses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchResponse)) {
            return false;
        }
        PutRecordBatchResponse other = (PutRecordBatchResponse) obj;
        return Objects.equals(failedPutCount(), other.failedPutCount()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(requestResponses(), other.requestResponses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutRecordBatchResponse").add("FailedPutCount", failedPutCount()).add("Encrypted", encrypted())
                .add("RequestResponses", requestResponses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedPutCount":
            return Optional.ofNullable(clazz.cast(failedPutCount()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "RequestResponses":
            return Optional.ofNullable(clazz.cast(requestResponses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordBatchResponse, T> g) {
        return obj -> g.apply((PutRecordBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutRecordBatchResponse> {
        /**
         * <p>
         * The number of records that might have failed processing. This number might be greater than 0 even if the
         * <a>PutRecordBatch</a> call succeeds. Check <code>FailedPutCount</code> to determine whether there are records
         * that you need to resend.
         * </p>
         * 
         * @param failedPutCount
         *        The number of records that might have failed processing. This number might be greater than 0 even if
         *        the <a>PutRecordBatch</a> call succeeds. Check <code>FailedPutCount</code> to determine whether there
         *        are records that you need to resend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedPutCount(Integer failedPutCount);

        /**
         * <p>
         * Indicates whether server-side encryption (SSE) was enabled during this operation.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether server-side encryption (SSE) was enabled during this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The results array. For each record, the index of the response element is the same as the index used in the
         * request array.
         * </p>
         * 
         * @param requestResponses
         *        The results array. For each record, the index of the response element is the same as the index used in
         *        the request array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestResponses(Collection<PutRecordBatchResponseEntry> requestResponses);

        /**
         * <p>
         * The results array. For each record, the index of the response element is the same as the index used in the
         * request array.
         * </p>
         * 
         * @param requestResponses
         *        The results array. For each record, the index of the response element is the same as the index used in
         *        the request array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestResponses(PutRecordBatchResponseEntry... requestResponses);

        /**
         * <p>
         * The results array. For each record, the index of the response element is the same as the index used in the
         * request array.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PutRecordBatchResponseEntry>.Builder}
         * avoiding the need to create one manually via {@link List<PutRecordBatchResponseEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PutRecordBatchResponseEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #requestResponses(List<PutRecordBatchResponseEntry>)}.
         * 
         * @param requestResponses
         *        a consumer that will call methods on {@link List<PutRecordBatchResponseEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestResponses(List<PutRecordBatchResponseEntry>)
         */
        Builder requestResponses(Consumer<PutRecordBatchResponseEntry.Builder>... requestResponses);
    }

    static final class BuilderImpl extends FirehoseResponse.BuilderImpl implements Builder {
        private Integer failedPutCount;

        private Boolean encrypted;

        private List<PutRecordBatchResponseEntry> requestResponses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchResponse model) {
            super(model);
            failedPutCount(model.failedPutCount);
            encrypted(model.encrypted);
            requestResponses(model.requestResponses);
        }

        public final Integer getFailedPutCount() {
            return failedPutCount;
        }

        @Override
        public final Builder failedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
            return this;
        }

        public final void setFailedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final Collection<PutRecordBatchResponseEntry.Builder> getRequestResponses() {
            return requestResponses != null ? requestResponses.stream().map(PutRecordBatchResponseEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder requestResponses(Collection<PutRecordBatchResponseEntry> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copy(requestResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestResponses(PutRecordBatchResponseEntry... requestResponses) {
            requestResponses(Arrays.asList(requestResponses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestResponses(Consumer<PutRecordBatchResponseEntry.Builder>... requestResponses) {
            requestResponses(Stream.of(requestResponses).map(c -> PutRecordBatchResponseEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRequestResponses(Collection<PutRecordBatchResponseEntry.BuilderImpl> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copyFromBuilder(requestResponses);
        }

        @Override
        public PutRecordBatchResponse build() {
            return new PutRecordBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
