/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OrcCompression {
    NONE("NONE"),
    ZLIB("ZLIB"),
    SNAPPY("SNAPPY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OrcCompression> VALUE_MAP;
    private final String value;

    private OrcCompression(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrcCompression fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OrcCompression> knownValues() {
        EnumSet<OrcCompression> knownValues = EnumSet.allOf(OrcCompression.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OrcCompression.class, OrcCompression::toString);
    }
}

