/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authentication configuration of the Amazon MSK cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationConfiguration.Builder, AuthenticationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(AuthenticationConfiguration::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> CONNECTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Connectivity").getter(getter(AuthenticationConfiguration::connectivityAsString))
            .setter(setter(Builder::connectivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connectivity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            CONNECTIVITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleARN;

    private final String connectivity;

    private AuthenticationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.connectivity = builder.connectivity;
    }

    /**
     * <p>
     * The ARN of the role used to access the Amazon MSK cluster.
     * </p>
     * 
     * @return The ARN of the role used to access the Amazon MSK cluster.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The type of connectivity used to access the Amazon MSK cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectivity} will
     * return {@link Connectivity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectivityAsString}.
     * </p>
     * 
     * @return The type of connectivity used to access the Amazon MSK cluster.
     * @see Connectivity
     */
    public final Connectivity connectivity() {
        return Connectivity.fromValue(connectivity);
    }

    /**
     * <p>
     * The type of connectivity used to access the Amazon MSK cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectivity} will
     * return {@link Connectivity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectivityAsString}.
     * </p>
     * 
     * @return The type of connectivity used to access the Amazon MSK cluster.
     * @see Connectivity
     */
    public final String connectivityAsString() {
        return connectivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(connectivityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfiguration)) {
            return false;
        }
        AuthenticationConfiguration other = (AuthenticationConfiguration) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(connectivityAsString(), other.connectivityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationConfiguration").add("RoleARN", roleARN())
                .add("Connectivity", connectivityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "Connectivity":
            return Optional.ofNullable(clazz.cast(connectivityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfiguration, T> g) {
        return obj -> g.apply((AuthenticationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationConfiguration> {
        /**
         * <p>
         * The ARN of the role used to access the Amazon MSK cluster.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the role used to access the Amazon MSK cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The type of connectivity used to access the Amazon MSK cluster.
         * </p>
         * 
         * @param connectivity
         *        The type of connectivity used to access the Amazon MSK cluster.
         * @see Connectivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Connectivity
         */
        Builder connectivity(String connectivity);

        /**
         * <p>
         * The type of connectivity used to access the Amazon MSK cluster.
         * </p>
         * 
         * @param connectivity
         *        The type of connectivity used to access the Amazon MSK cluster.
         * @see Connectivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Connectivity
         */
        Builder connectivity(Connectivity connectivity);
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String connectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfiguration model) {
            roleARN(model.roleARN);
            connectivity(model.connectivity);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getConnectivity() {
            return connectivity;
        }

        public final void setConnectivity(String connectivity) {
            this.connectivity = connectivity;
        }

        @Override
        public final Builder connectivity(String connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        @Override
        public final Builder connectivity(Connectivity connectivity) {
            this.connectivity(connectivity == null ? null : connectivity.toString());
            return this;
        }

        @Override
        public AuthenticationConfiguration build() {
            return new AuthenticationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
