/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisStreamSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisStreamSourceConfiguration> {
    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KinesisStreamARN").getter(KinesisStreamSourceConfiguration.getter(KinesisStreamSourceConfiguration::kinesisStreamARN)).setter(KinesisStreamSourceConfiguration.setter(Builder::kinesisStreamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamARN").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(KinesisStreamSourceConfiguration.getter(KinesisStreamSourceConfiguration::roleARN)).setter(KinesisStreamSourceConfiguration.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KINESIS_STREAM_ARN_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kinesisStreamARN;
    private final String roleARN;

    private KinesisStreamSourceConfiguration(BuilderImpl builder) {
        this.kinesisStreamARN = builder.kinesisStreamARN;
        this.roleARN = builder.roleARN;
    }

    public final String kinesisStreamARN() {
        return this.kinesisStreamARN;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamSourceConfiguration)) {
            return false;
        }
        KinesisStreamSourceConfiguration other = (KinesisStreamSourceConfiguration)obj;
        return Objects.equals(this.kinesisStreamARN(), other.kinesisStreamARN()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisStreamSourceConfiguration").add("KinesisStreamARN", (Object)this.kinesisStreamARN()).add("RoleARN", (Object)this.roleARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KinesisStreamARN": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisStreamSourceConfiguration, T> g) {
        return obj -> g.apply((KinesisStreamSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kinesisStreamARN;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamSourceConfiguration model) {
            this.kinesisStreamARN(model.kinesisStreamARN);
            this.roleARN(model.roleARN);
        }

        public final String getKinesisStreamARN() {
            return this.kinesisStreamARN;
        }

        public final void setKinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
        }

        @Override
        public final Builder kinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public KinesisStreamSourceConfiguration build() {
            return new KinesisStreamSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisStreamSourceConfiguration> {
        public Builder kinesisStreamARN(String var1);

        public Builder roleARN(String var1);
    }
}

