/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.Serializer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputFormatConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputFormatConfiguration> {
    private static final SdkField<Serializer> SERIALIZER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Serializer").getter(OutputFormatConfiguration.getter(OutputFormatConfiguration::serializer)).setter(OutputFormatConfiguration.setter(Builder::serializer)).constructor(Serializer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Serializer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERIALIZER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Serializer serializer;

    private OutputFormatConfiguration(BuilderImpl builder) {
        this.serializer = builder.serializer;
    }

    public final Serializer serializer() {
        return this.serializer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serializer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputFormatConfiguration)) {
            return false;
        }
        OutputFormatConfiguration other = (OutputFormatConfiguration)obj;
        return Objects.equals(this.serializer(), other.serializer());
    }

    public final String toString() {
        return ToString.builder((String)"OutputFormatConfiguration").add("Serializer", (Object)this.serializer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Serializer": {
                return Optional.ofNullable(clazz.cast(this.serializer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputFormatConfiguration, T> g) {
        return obj -> g.apply((OutputFormatConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Serializer serializer;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputFormatConfiguration model) {
            this.serializer(model.serializer);
        }

        public final Serializer.Builder getSerializer() {
            return this.serializer != null ? this.serializer.toBuilder() : null;
        }

        public final void setSerializer(Serializer.BuilderImpl serializer) {
            this.serializer = serializer != null ? serializer.build() : null;
        }

        @Override
        @Transient
        public final Builder serializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public OutputFormatConfiguration build() {
            return new OutputFormatConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputFormatConfiguration> {
        public Builder serializer(Serializer var1);

        default public Builder serializer(Consumer<Serializer.Builder> serializer) {
            return this.serializer((Serializer)((Serializer.Builder)Serializer.builder().applyMutation(serializer)).build());
        }
    }
}

