/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspacedata.FinspaceDataClient;
import software.amazon.awssdk.services.finspacedata.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspacedata.model.ChangesetSummary;
import software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest;
import software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse;

public class ListChangesetsIterable
implements SdkIterable<ListChangesetsResponse> {
    private final FinspaceDataClient client;
    private final ListChangesetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChangesetsIterable(FinspaceDataClient client, ListChangesetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChangesetsResponseFetcher();
    }

    public Iterator<ListChangesetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChangesetSummary> changesets() {
        Function<ListChangesetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.changesets() != null) {
                return response.changesets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListChangesetsResponseFetcher
    implements SyncPageFetcher<ListChangesetsResponse> {
        private ListChangesetsResponseFetcher() {
        }

        public boolean hasNextPage(ListChangesetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChangesetsResponse nextPage(ListChangesetsResponse previousPage) {
            if (previousPage == null) {
                return ListChangesetsIterable.this.client.listChangesets(ListChangesetsIterable.this.firstRequest);
            }
            return ListChangesetsIterable.this.client.listChangesets((ListChangesetsRequest)((Object)ListChangesetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

