/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FederationMode {
    FEDERATED("FEDERATED"),
    LOCAL("LOCAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FederationMode> VALUE_MAP;
    private final String value;

    private FederationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FederationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FederationMode> knownValues() {
        EnumSet<FederationMode> knownValues = EnumSet.allOf(FederationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FederationMode.class, FederationMode::toString);
    }
}

