/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspace.model.AutoScalingConfiguration;
import software.amazon.awssdk.services.finspace.model.CapacityConfiguration;
import software.amazon.awssdk.services.finspace.model.CodeConfiguration;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.KxAzMode;
import software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration;
import software.amazon.awssdk.services.finspace.model.KxCacheStorageConfigurationsCopier;
import software.amazon.awssdk.services.finspace.model.KxClusterType;
import software.amazon.awssdk.services.finspace.model.KxCommandLineArgument;
import software.amazon.awssdk.services.finspace.model.KxCommandLineArgumentsCopier;
import software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration;
import software.amazon.awssdk.services.finspace.model.KxDatabaseConfigurationsCopier;
import software.amazon.awssdk.services.finspace.model.KxSavedownStorageConfiguration;
import software.amazon.awssdk.services.finspace.model.TagMapCopier;
import software.amazon.awssdk.services.finspace.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKxClusterRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, CreateKxClusterRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::clientToken)).setter(CreateKxClusterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::environmentId)).setter(CreateKxClusterRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::clusterName)).setter(CreateKxClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterType").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::clusterTypeAsString)).setter(CreateKxClusterRequest.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()}).build();
    private static final SdkField<List<KxDatabaseConfiguration>> DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("databases").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::databases)).setter(CreateKxClusterRequest.setter(Builder::databases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDatabaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KxCacheStorageConfiguration>> CACHE_STORAGE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cacheStorageConfigurations").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::cacheStorageConfigurations)).setter(CreateKxClusterRequest.setter(Builder::cacheStorageConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheStorageConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxCacheStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoScalingConfiguration> AUTO_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoScalingConfiguration").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::autoScalingConfiguration)).setter(CreateKxClusterRequest.setter(Builder::autoScalingConfiguration)).constructor(AutoScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingConfiguration").build()}).build();
    private static final SdkField<String> CLUSTER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterDescription").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::clusterDescription)).setter(CreateKxClusterRequest.setter(Builder::clusterDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterDescription").build()}).build();
    private static final SdkField<CapacityConfiguration> CAPACITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacityConfiguration").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::capacityConfiguration)).setter(CreateKxClusterRequest.setter(Builder::capacityConfiguration)).constructor(CapacityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityConfiguration").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::releaseLabel)).setter(CreateKxClusterRequest.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::vpcConfiguration)).setter(CreateKxClusterRequest.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final SdkField<String> INITIALIZATION_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initializationScript").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::initializationScript)).setter(CreateKxClusterRequest.setter(Builder::initializationScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScript").build()}).build();
    private static final SdkField<List<KxCommandLineArgument>> COMMAND_LINE_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commandLineArguments").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::commandLineArguments)).setter(CreateKxClusterRequest.setter(Builder::commandLineArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandLineArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxCommandLineArgument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CodeConfiguration> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("code").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::code)).setter(CreateKxClusterRequest.setter(Builder::code)).constructor(CodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::executionRole)).setter(CreateKxClusterRequest.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<KxSavedownStorageConfiguration> SAVEDOWN_STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savedownStorageConfiguration").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::savedownStorageConfiguration)).setter(CreateKxClusterRequest.setter(Builder::savedownStorageConfiguration)).constructor(KxSavedownStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savedownStorageConfiguration").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("azMode").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::azModeAsString)).setter(CreateKxClusterRequest.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::availabilityZoneId)).setter(CreateKxClusterRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateKxClusterRequest.getter(CreateKxClusterRequest::tags)).setter(CreateKxClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ENVIRONMENT_ID_FIELD, CLUSTER_NAME_FIELD, CLUSTER_TYPE_FIELD, DATABASES_FIELD, CACHE_STORAGE_CONFIGURATIONS_FIELD, AUTO_SCALING_CONFIGURATION_FIELD, CLUSTER_DESCRIPTION_FIELD, CAPACITY_CONFIGURATION_FIELD, RELEASE_LABEL_FIELD, VPC_CONFIGURATION_FIELD, INITIALIZATION_SCRIPT_FIELD, COMMAND_LINE_ARGUMENTS_FIELD, CODE_FIELD, EXECUTION_ROLE_FIELD, SAVEDOWN_STORAGE_CONFIGURATION_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_ID_FIELD, TAGS_FIELD));
    private final String clientToken;
    private final String environmentId;
    private final String clusterName;
    private final String clusterType;
    private final List<KxDatabaseConfiguration> databases;
    private final List<KxCacheStorageConfiguration> cacheStorageConfigurations;
    private final AutoScalingConfiguration autoScalingConfiguration;
    private final String clusterDescription;
    private final CapacityConfiguration capacityConfiguration;
    private final String releaseLabel;
    private final VpcConfiguration vpcConfiguration;
    private final String initializationScript;
    private final List<KxCommandLineArgument> commandLineArguments;
    private final CodeConfiguration code;
    private final String executionRole;
    private final KxSavedownStorageConfiguration savedownStorageConfiguration;
    private final String azMode;
    private final String availabilityZoneId;
    private final Map<String, String> tags;

    private CreateKxClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.environmentId = builder.environmentId;
        this.clusterName = builder.clusterName;
        this.clusterType = builder.clusterType;
        this.databases = builder.databases;
        this.cacheStorageConfigurations = builder.cacheStorageConfigurations;
        this.autoScalingConfiguration = builder.autoScalingConfiguration;
        this.clusterDescription = builder.clusterDescription;
        this.capacityConfiguration = builder.capacityConfiguration;
        this.releaseLabel = builder.releaseLabel;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.initializationScript = builder.initializationScript;
        this.commandLineArguments = builder.commandLineArguments;
        this.code = builder.code;
        this.executionRole = builder.executionRole;
        this.savedownStorageConfiguration = builder.savedownStorageConfiguration;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final KxClusterType clusterType() {
        return KxClusterType.fromValue(this.clusterType);
    }

    public final String clusterTypeAsString() {
        return this.clusterType;
    }

    public final boolean hasDatabases() {
        return this.databases != null && !(this.databases instanceof SdkAutoConstructList);
    }

    public final List<KxDatabaseConfiguration> databases() {
        return this.databases;
    }

    public final boolean hasCacheStorageConfigurations() {
        return this.cacheStorageConfigurations != null && !(this.cacheStorageConfigurations instanceof SdkAutoConstructList);
    }

    public final List<KxCacheStorageConfiguration> cacheStorageConfigurations() {
        return this.cacheStorageConfigurations;
    }

    public final AutoScalingConfiguration autoScalingConfiguration() {
        return this.autoScalingConfiguration;
    }

    public final String clusterDescription() {
        return this.clusterDescription;
    }

    public final CapacityConfiguration capacityConfiguration() {
        return this.capacityConfiguration;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final String initializationScript() {
        return this.initializationScript;
    }

    public final boolean hasCommandLineArguments() {
        return this.commandLineArguments != null && !(this.commandLineArguments instanceof SdkAutoConstructList);
    }

    public final List<KxCommandLineArgument> commandLineArguments() {
        return this.commandLineArguments;
    }

    public final CodeConfiguration code() {
        return this.code;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final KxSavedownStorageConfiguration savedownStorageConfiguration() {
        return this.savedownStorageConfiguration;
    }

    public final KxAzMode azMode() {
        return KxAzMode.fromValue(this.azMode);
    }

    public final String azModeAsString() {
        return this.azMode;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabases() ? this.databases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheStorageConfigurations() ? this.cacheStorageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommandLineArguments() ? this.commandLineArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.savedownStorageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxClusterRequest)) {
            return false;
        }
        CreateKxClusterRequest other = (CreateKxClusterRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.clusterTypeAsString(), other.clusterTypeAsString()) && this.hasDatabases() == other.hasDatabases() && Objects.equals(this.databases(), other.databases()) && this.hasCacheStorageConfigurations() == other.hasCacheStorageConfigurations() && Objects.equals(this.cacheStorageConfigurations(), other.cacheStorageConfigurations()) && Objects.equals(this.autoScalingConfiguration(), other.autoScalingConfiguration()) && Objects.equals(this.clusterDescription(), other.clusterDescription()) && Objects.equals(this.capacityConfiguration(), other.capacityConfiguration()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.initializationScript(), other.initializationScript()) && this.hasCommandLineArguments() == other.hasCommandLineArguments() && Objects.equals(this.commandLineArguments(), other.commandLineArguments()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.savedownStorageConfiguration(), other.savedownStorageConfiguration()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKxClusterRequest").add("ClientToken", (Object)this.clientToken()).add("EnvironmentId", (Object)this.environmentId()).add("ClusterName", (Object)this.clusterName()).add("ClusterType", (Object)this.clusterTypeAsString()).add("Databases", this.hasDatabases() ? this.databases() : null).add("CacheStorageConfigurations", this.hasCacheStorageConfigurations() ? this.cacheStorageConfigurations() : null).add("AutoScalingConfiguration", (Object)this.autoScalingConfiguration()).add("ClusterDescription", (Object)this.clusterDescription()).add("CapacityConfiguration", (Object)this.capacityConfiguration()).add("ReleaseLabel", (Object)this.releaseLabel()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("InitializationScript", (Object)this.initializationScript()).add("CommandLineArguments", this.hasCommandLineArguments() ? this.commandLineArguments() : null).add("Code", (Object)this.code()).add("ExecutionRole", (Object)this.executionRole()).add("SavedownStorageConfiguration", (Object)this.savedownStorageConfiguration()).add("AzMode", (Object)this.azModeAsString()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "clusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterTypeAsString()));
            }
            case "databases": {
                return Optional.ofNullable(clazz.cast(this.databases()));
            }
            case "cacheStorageConfigurations": {
                return Optional.ofNullable(clazz.cast(this.cacheStorageConfigurations()));
            }
            case "autoScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfiguration()));
            }
            case "clusterDescription": {
                return Optional.ofNullable(clazz.cast(this.clusterDescription()));
            }
            case "capacityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.capacityConfiguration()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "initializationScript": {
                return Optional.ofNullable(clazz.cast(this.initializationScript()));
            }
            case "commandLineArguments": {
                return Optional.ofNullable(clazz.cast(this.commandLineArguments()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "savedownStorageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.savedownStorageConfiguration()));
            }
            case "azMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKxClusterRequest, T> g) {
        return obj -> g.apply((CreateKxClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String environmentId;
        private String clusterName;
        private String clusterType;
        private List<KxDatabaseConfiguration> databases = DefaultSdkAutoConstructList.getInstance();
        private List<KxCacheStorageConfiguration> cacheStorageConfigurations = DefaultSdkAutoConstructList.getInstance();
        private AutoScalingConfiguration autoScalingConfiguration;
        private String clusterDescription;
        private CapacityConfiguration capacityConfiguration;
        private String releaseLabel;
        private VpcConfiguration vpcConfiguration;
        private String initializationScript;
        private List<KxCommandLineArgument> commandLineArguments = DefaultSdkAutoConstructList.getInstance();
        private CodeConfiguration code;
        private String executionRole;
        private KxSavedownStorageConfiguration savedownStorageConfiguration;
        private String azMode;
        private String availabilityZoneId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxClusterRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.environmentId(model.environmentId);
            this.clusterName(model.clusterName);
            this.clusterType(model.clusterType);
            this.databases(model.databases);
            this.cacheStorageConfigurations(model.cacheStorageConfigurations);
            this.autoScalingConfiguration(model.autoScalingConfiguration);
            this.clusterDescription(model.clusterDescription);
            this.capacityConfiguration(model.capacityConfiguration);
            this.releaseLabel(model.releaseLabel);
            this.vpcConfiguration(model.vpcConfiguration);
            this.initializationScript(model.initializationScript);
            this.commandLineArguments(model.commandLineArguments);
            this.code(model.code);
            this.executionRole(model.executionRole);
            this.savedownStorageConfiguration(model.savedownStorageConfiguration);
            this.azMode(model.azMode);
            this.availabilityZoneId(model.availabilityZoneId);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(KxClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final List<KxDatabaseConfiguration.Builder> getDatabases() {
            List<KxDatabaseConfiguration.Builder> result = KxDatabaseConfigurationsCopier.copyToBuilder(this.databases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabases(Collection<KxDatabaseConfiguration.BuilderImpl> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copyFromBuilder(databases);
        }

        @Override
        public final Builder databases(Collection<KxDatabaseConfiguration> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(KxDatabaseConfiguration ... databases) {
            this.databases(Arrays.asList(databases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(Consumer<KxDatabaseConfiguration.Builder> ... databases) {
            this.databases(Stream.of(databases).map(c -> (KxDatabaseConfiguration)((KxDatabaseConfiguration.Builder)KxDatabaseConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KxCacheStorageConfiguration.Builder> getCacheStorageConfigurations() {
            List<KxCacheStorageConfiguration.Builder> result = KxCacheStorageConfigurationsCopier.copyToBuilder(this.cacheStorageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheStorageConfigurations(Collection<KxCacheStorageConfiguration.BuilderImpl> cacheStorageConfigurations) {
            this.cacheStorageConfigurations = KxCacheStorageConfigurationsCopier.copyFromBuilder(cacheStorageConfigurations);
        }

        @Override
        public final Builder cacheStorageConfigurations(Collection<KxCacheStorageConfiguration> cacheStorageConfigurations) {
            this.cacheStorageConfigurations = KxCacheStorageConfigurationsCopier.copy(cacheStorageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheStorageConfigurations(KxCacheStorageConfiguration ... cacheStorageConfigurations) {
            this.cacheStorageConfigurations(Arrays.asList(cacheStorageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheStorageConfigurations(Consumer<KxCacheStorageConfiguration.Builder> ... cacheStorageConfigurations) {
            this.cacheStorageConfigurations(Stream.of(cacheStorageConfigurations).map(c -> (KxCacheStorageConfiguration)((KxCacheStorageConfiguration.Builder)KxCacheStorageConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoScalingConfiguration.Builder getAutoScalingConfiguration() {
            return this.autoScalingConfiguration != null ? this.autoScalingConfiguration.toBuilder() : null;
        }

        public final void setAutoScalingConfiguration(AutoScalingConfiguration.BuilderImpl autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration != null ? autoScalingConfiguration.build() : null;
        }

        @Override
        public final Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration;
            return this;
        }

        public final String getClusterDescription() {
            return this.clusterDescription;
        }

        public final void setClusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
        }

        @Override
        public final Builder clusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
            return this;
        }

        public final CapacityConfiguration.Builder getCapacityConfiguration() {
            return this.capacityConfiguration != null ? this.capacityConfiguration.toBuilder() : null;
        }

        public final void setCapacityConfiguration(CapacityConfiguration.BuilderImpl capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration != null ? capacityConfiguration.build() : null;
        }

        @Override
        public final Builder capacityConfiguration(CapacityConfiguration capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getInitializationScript() {
            return this.initializationScript;
        }

        public final void setInitializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
        }

        @Override
        public final Builder initializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
            return this;
        }

        public final List<KxCommandLineArgument.Builder> getCommandLineArguments() {
            List<KxCommandLineArgument.Builder> result = KxCommandLineArgumentsCopier.copyToBuilder(this.commandLineArguments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommandLineArguments(Collection<KxCommandLineArgument.BuilderImpl> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copyFromBuilder(commandLineArguments);
        }

        @Override
        public final Builder commandLineArguments(Collection<KxCommandLineArgument> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copy(commandLineArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(KxCommandLineArgument ... commandLineArguments) {
            this.commandLineArguments(Arrays.asList(commandLineArguments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder> ... commandLineArguments) {
            this.commandLineArguments(Stream.of(commandLineArguments).map(c -> (KxCommandLineArgument)((KxCommandLineArgument.Builder)KxCommandLineArgument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CodeConfiguration.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(CodeConfiguration.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(CodeConfiguration code) {
            this.code = code;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final KxSavedownStorageConfiguration.Builder getSavedownStorageConfiguration() {
            return this.savedownStorageConfiguration != null ? this.savedownStorageConfiguration.toBuilder() : null;
        }

        public final void setSavedownStorageConfiguration(KxSavedownStorageConfiguration.BuilderImpl savedownStorageConfiguration) {
            this.savedownStorageConfiguration = savedownStorageConfiguration != null ? savedownStorageConfiguration.build() : null;
        }

        @Override
        public final Builder savedownStorageConfiguration(KxSavedownStorageConfiguration savedownStorageConfiguration) {
            this.savedownStorageConfiguration = savedownStorageConfiguration;
            return this;
        }

        public final String getAzMode() {
            return this.azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKxClusterRequest build() {
            return new CreateKxClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKxClusterRequest> {
        public Builder clientToken(String var1);

        public Builder environmentId(String var1);

        public Builder clusterName(String var1);

        public Builder clusterType(String var1);

        public Builder clusterType(KxClusterType var1);

        public Builder databases(Collection<KxDatabaseConfiguration> var1);

        public Builder databases(KxDatabaseConfiguration ... var1);

        public Builder databases(Consumer<KxDatabaseConfiguration.Builder> ... var1);

        public Builder cacheStorageConfigurations(Collection<KxCacheStorageConfiguration> var1);

        public Builder cacheStorageConfigurations(KxCacheStorageConfiguration ... var1);

        public Builder cacheStorageConfigurations(Consumer<KxCacheStorageConfiguration.Builder> ... var1);

        public Builder autoScalingConfiguration(AutoScalingConfiguration var1);

        default public Builder autoScalingConfiguration(Consumer<AutoScalingConfiguration.Builder> autoScalingConfiguration) {
            return this.autoScalingConfiguration((AutoScalingConfiguration)((AutoScalingConfiguration.Builder)AutoScalingConfiguration.builder().applyMutation(autoScalingConfiguration)).build());
        }

        public Builder clusterDescription(String var1);

        public Builder capacityConfiguration(CapacityConfiguration var1);

        default public Builder capacityConfiguration(Consumer<CapacityConfiguration.Builder> capacityConfiguration) {
            return this.capacityConfiguration((CapacityConfiguration)((CapacityConfiguration.Builder)CapacityConfiguration.builder().applyMutation(capacityConfiguration)).build());
        }

        public Builder releaseLabel(String var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder initializationScript(String var1);

        public Builder commandLineArguments(Collection<KxCommandLineArgument> var1);

        public Builder commandLineArguments(KxCommandLineArgument ... var1);

        public Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder> ... var1);

        public Builder code(CodeConfiguration var1);

        default public Builder code(Consumer<CodeConfiguration.Builder> code) {
            return this.code((CodeConfiguration)((CodeConfiguration.Builder)CodeConfiguration.builder().applyMutation(code)).build());
        }

        public Builder executionRole(String var1);

        public Builder savedownStorageConfiguration(KxSavedownStorageConfiguration var1);

        default public Builder savedownStorageConfiguration(Consumer<KxSavedownStorageConfiguration.Builder> savedownStorageConfiguration) {
            return this.savedownStorageConfiguration((KxSavedownStorageConfiguration)((KxSavedownStorageConfiguration.Builder)KxSavedownStorageConfiguration.builder().applyMutation(savedownStorageConfiguration)).build());
        }

        public Builder azMode(String var1);

        public Builder azMode(KxAzMode var1);

        public Builder availabilityZoneId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

