/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeConfiguration> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Bucket").getter(CodeConfiguration.getter(CodeConfiguration::s3Bucket)).setter(CodeConfiguration.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Key").getter(CodeConfiguration.getter(CodeConfiguration::s3Key)).setter(CodeConfiguration.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()}).build();
    private static final SdkField<String> S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3ObjectVersion").getter(CodeConfiguration.getter(CodeConfiguration::s3ObjectVersion)).setter(CodeConfiguration.setter(Builder::s3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ObjectVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_KEY_FIELD, S3_OBJECT_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Bucket;
    private final String s3Key;
    private final String s3ObjectVersion;

    private CodeConfiguration(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Key() {
        return this.s3Key;
    }

    public final String s3ObjectVersion() {
        return this.s3ObjectVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ObjectVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeConfiguration)) {
            return false;
        }
        CodeConfiguration other = (CodeConfiguration)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.s3ObjectVersion(), other.s3ObjectVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CodeConfiguration").add("S3Bucket", (Object)this.s3Bucket()).add("S3Key", (Object)this.s3Key()).add("S3ObjectVersion", (Object)this.s3ObjectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "s3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
            case "s3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.s3ObjectVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeConfiguration, T> g) {
        return obj -> g.apply((CodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Bucket;
        private String s3Key;
        private String s3ObjectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeConfiguration model) {
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
            this.s3ObjectVersion(model.s3ObjectVersion);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final String getS3ObjectVersion() {
            return this.s3ObjectVersion;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public CodeConfiguration build() {
            return new CodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeConfiguration> {
        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder s3ObjectVersion(String var1);
    }
}

