/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest;
import software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse;

public class ListKxClusterNodesIterable
implements SdkIterable<ListKxClusterNodesResponse> {
    private final FinspaceClient client;
    private final ListKxClusterNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKxClusterNodesIterable(FinspaceClient client, ListKxClusterNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKxClusterNodesResponseFetcher();
    }

    public Iterator<ListKxClusterNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListKxClusterNodesResponseFetcher
    implements SyncPageFetcher<ListKxClusterNodesResponse> {
        private ListKxClusterNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListKxClusterNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKxClusterNodesResponse nextPage(ListKxClusterNodesResponse previousPage) {
            if (previousPage == null) {
                return ListKxClusterNodesIterable.this.client.listKxClusterNodes(ListKxClusterNodesIterable.this.firstRequest);
            }
            return ListKxClusterNodesIterable.this.client.listKxClusterNodes((ListKxClusterNodesRequest)((Object)ListKxClusterNodesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

