/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxEnvironment;
import software.amazon.awssdk.services.finspace.model.KxEnvironmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKxEnvironmentsResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, ListKxEnvironmentsResponse> {
    private static final SdkField<List<KxEnvironment>> ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environments").getter(ListKxEnvironmentsResponse.getter(ListKxEnvironmentsResponse::environments)).setter(ListKxEnvironmentsResponse.setter(Builder::environments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListKxEnvironmentsResponse.getter(ListKxEnvironmentsResponse::nextToken)).setter(ListKxEnvironmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<KxEnvironment> environments;
    private final String nextToken;

    private ListKxEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environments = builder.environments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEnvironments() {
        return this.environments != null && !(this.environments instanceof SdkAutoConstructList);
    }

    public final List<KxEnvironment> environments() {
        return this.environments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironments() ? this.environments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxEnvironmentsResponse)) {
            return false;
        }
        ListKxEnvironmentsResponse other = (ListKxEnvironmentsResponse)((Object)obj);
        return this.hasEnvironments() == other.hasEnvironments() && Objects.equals(this.environments(), other.environments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListKxEnvironmentsResponse").add("Environments", this.hasEnvironments() ? this.environments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environments": {
                return Optional.ofNullable(clazz.cast(this.environments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKxEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListKxEnvironmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private List<KxEnvironment> environments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxEnvironmentsResponse model) {
            super(model);
            this.environments(model.environments);
            this.nextToken(model.nextToken);
        }

        public final List<KxEnvironment.Builder> getEnvironments() {
            List<KxEnvironment.Builder> result = KxEnvironmentListCopier.copyToBuilder(this.environments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironments(Collection<KxEnvironment.BuilderImpl> environments) {
            this.environments = KxEnvironmentListCopier.copyFromBuilder(environments);
        }

        @Override
        public final Builder environments(Collection<KxEnvironment> environments) {
            this.environments = KxEnvironmentListCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(KxEnvironment ... environments) {
            this.environments(Arrays.asList(environments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(Consumer<KxEnvironment.Builder> ... environments) {
            this.environments(Stream.of(environments).map(c -> (KxEnvironment)((KxEnvironment.Builder)KxEnvironment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKxEnvironmentsResponse build() {
            return new ListKxEnvironmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKxEnvironmentsResponse> {
        public Builder environments(Collection<KxEnvironment> var1);

        public Builder environments(KxEnvironment ... var1);

        public Builder environments(Consumer<KxEnvironment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

