/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopLaunchRequest extends EvidentlyRequest implements
        ToCopyableBuilder<StopLaunchRequest.Builder, StopLaunchRequest> {
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredState").getter(getter(StopLaunchRequest::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredState").build()).build();

    private static final SdkField<String> LAUNCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("launch")
            .getter(getter(StopLaunchRequest::launch)).setter(setter(Builder::launch))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("launch").build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(StopLaunchRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(StopLaunchRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD,
            LAUNCH_FIELD, PROJECT_FIELD, REASON_FIELD));

    private final String desiredState;

    private final String launch;

    private final String project;

    private final String reason;

    private StopLaunchRequest(BuilderImpl builder) {
        super(builder);
        this.desiredState = builder.desiredState;
        this.launch = builder.launch;
        this.project = builder.project;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link LaunchStopDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it
     *         stops.
     * @see LaunchStopDesiredState
     */
    public final LaunchStopDesiredState desiredState() {
        return LaunchStopDesiredState.fromValue(desiredState);
    }

    /**
     * <p>
     * Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link LaunchStopDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it
     *         stops.
     * @see LaunchStopDesiredState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * The name of the launch to stop.
     * </p>
     * 
     * @return The name of the launch to stop.
     */
    public final String launch() {
        return launch;
    }

    /**
     * <p>
     * The name or ARN of the project that contains the launch that you want to stop.
     * </p>
     * 
     * @return The name or ARN of the project that contains the launch that you want to stop.
     */
    public final String project() {
        return project;
    }

    /**
     * <p>
     * A string that describes why you are stopping the launch.
     * </p>
     * 
     * @return A string that describes why you are stopping the launch.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launch());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopLaunchRequest)) {
            return false;
        }
        StopLaunchRequest other = (StopLaunchRequest) obj;
        return Objects.equals(desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(launch(), other.launch())
                && Objects.equals(project(), other.project()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopLaunchRequest").add("DesiredState", desiredStateAsString()).add("Launch", launch())
                .add("Project", project()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "desiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "launch":
            return Optional.ofNullable(clazz.cast(launch()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopLaunchRequest, T> g) {
        return obj -> g.apply((StopLaunchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopLaunchRequest> {
        /**
         * <p>
         * Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.
         * </p>
         * 
         * @param desiredState
         *        Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it
         *        stops.
         * @see LaunchStopDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchStopDesiredState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.
         * </p>
         * 
         * @param desiredState
         *        Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it
         *        stops.
         * @see LaunchStopDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchStopDesiredState
         */
        Builder desiredState(LaunchStopDesiredState desiredState);

        /**
         * <p>
         * The name of the launch to stop.
         * </p>
         * 
         * @param launch
         *        The name of the launch to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launch(String launch);

        /**
         * <p>
         * The name or ARN of the project that contains the launch that you want to stop.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains the launch that you want to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        /**
         * <p>
         * A string that describes why you are stopping the launch.
         * </p>
         * 
         * @param reason
         *        A string that describes why you are stopping the launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String desiredState;

        private String launch;

        private String project;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopLaunchRequest model) {
            super(model);
            desiredState(model.desiredState);
            launch(model.launch);
            project(model.project);
            reason(model.reason);
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(LaunchStopDesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getLaunch() {
            return launch;
        }

        public final void setLaunch(String launch) {
            this.launch = launch;
        }

        @Override
        public final Builder launch(String launch) {
            this.launch = launch;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopLaunchRequest build() {
            return new StopLaunchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
