/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.evidently.DefaultEvidentlyBaseClientBuilder;
import software.amazon.awssdk.services.evidently.DefaultEvidentlyClient;
import software.amazon.awssdk.services.evidently.EvidentlyClient;
import software.amazon.awssdk.services.evidently.EvidentlyClientBuilder;
import software.amazon.awssdk.services.evidently.EvidentlyServiceClientConfiguration;
import software.amazon.awssdk.services.evidently.endpoints.EvidentlyEndpointProvider;

@SdkInternalApi
final class DefaultEvidentlyClientBuilder
extends DefaultEvidentlyBaseClientBuilder<EvidentlyClientBuilder, EvidentlyClient>
implements EvidentlyClientBuilder {
    DefaultEvidentlyClientBuilder() {
    }

    @Override
    public DefaultEvidentlyClientBuilder endpointProvider(EvidentlyEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EvidentlyClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEvidentlyClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        EvidentlyServiceClientConfiguration serviceClientConfiguration = EvidentlyServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultEvidentlyClient(serviceClientConfiguration, clientConfiguration);
    }
}

