/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evidently.EvidentlyAsyncClient;
import software.amazon.awssdk.services.evidently.model.ListSegmentReferencesRequest;
import software.amazon.awssdk.services.evidently.model.ListSegmentReferencesResponse;
import software.amazon.awssdk.services.evidently.model.RefResource;

public class ListSegmentReferencesPublisher
implements SdkPublisher<ListSegmentReferencesResponse> {
    private final EvidentlyAsyncClient client;
    private final ListSegmentReferencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSegmentReferencesPublisher(EvidentlyAsyncClient client, ListSegmentReferencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSegmentReferencesPublisher(EvidentlyAsyncClient client, ListSegmentReferencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSegmentReferencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSegmentReferencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RefResource> referencedBy() {
        Function<ListSegmentReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.referencedBy() != null) {
                return response.referencedBy().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSegmentReferencesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSegmentReferencesResponseFetcher
    implements AsyncPageFetcher<ListSegmentReferencesResponse> {
        private ListSegmentReferencesResponseFetcher() {
        }

        public boolean hasNextPage(ListSegmentReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSegmentReferencesResponse> nextPage(ListSegmentReferencesResponse previousPage) {
            if (previousPage == null) {
                return ListSegmentReferencesPublisher.this.client.listSegmentReferences(ListSegmentReferencesPublisher.this.firstRequest);
            }
            return ListSegmentReferencesPublisher.this.client.listSegmentReferences((ListSegmentReferencesRequest)((Object)ListSegmentReferencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

