/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse;
import software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary;

public class ListSchemaMappingsPublisher
implements SdkPublisher<ListSchemaMappingsResponse> {
    private final EntityResolutionAsyncClient client;
    private final ListSchemaMappingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSchemaMappingsPublisher(EntityResolutionAsyncClient client, ListSchemaMappingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSchemaMappingsPublisher(EntityResolutionAsyncClient client, ListSchemaMappingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSchemaMappingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSchemaMappingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SchemaMappingSummary> schemaList() {
        Function<ListSchemaMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemaList() != null) {
                return response.schemaList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSchemaMappingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSchemaMappingsResponseFetcher
    implements AsyncPageFetcher<ListSchemaMappingsResponse> {
        private ListSchemaMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListSchemaMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSchemaMappingsResponse> nextPage(ListSchemaMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListSchemaMappingsPublisher.this.client.listSchemaMappings(ListSchemaMappingsPublisher.this.firstRequest);
            }
            return ListSchemaMappingsPublisher.this.client.listSchemaMappings((ListSchemaMappingsRequest)((Object)ListSchemaMappingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

