/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.JobSummary;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse;

public class ListMatchingJobsIterable
implements SdkIterable<ListMatchingJobsResponse> {
    private final EntityResolutionClient client;
    private final ListMatchingJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMatchingJobsIterable(EntityResolutionClient client, ListMatchingJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMatchingJobsResponseFetcher();
    }

    public Iterator<ListMatchingJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobSummary> jobs() {
        Function<ListMatchingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMatchingJobsResponseFetcher
    implements SyncPageFetcher<ListMatchingJobsResponse> {
        private ListMatchingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMatchingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMatchingJobsResponse nextPage(ListMatchingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMatchingJobsIterable.this.client.listMatchingJobs(ListMatchingJobsIterable.this.firstRequest);
            }
            return ListMatchingJobsIterable.this.client.listMatchingJobs((ListMatchingJobsRequest)((Object)ListMatchingJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

