/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object which defines the list of matching rules to run and has a field <code>Rules</code>, which is a list of rule
 * objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleBasedProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleBasedProperties.Builder, RuleBasedProperties> {
    private static final SdkField<String> ATTRIBUTE_MATCHING_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeMatchingModel").getter(getter(RuleBasedProperties::attributeMatchingModelAsString))
            .setter(setter(Builder::attributeMatchingModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeMatchingModel").build())
            .build();

    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(RuleBasedProperties::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ATTRIBUTE_MATCHING_MODEL_FIELD, RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeMatchingModel;

    private final List<Rule> rules;

    private RuleBasedProperties(BuilderImpl builder) {
        this.attributeMatchingModel = builder.attributeMatchingModel;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the AttributeMatchingModel. When
     * choosing <code>MANY_TO_MANY</code>, the system can match attribute across the sub-types of an attribute type. For
     * example, if the value of the Email field of Profile A and the value of BusinessEmail field of Profile B matches,
     * the two profiles are matched on the Email type. When choosing <code>ONE_TO_ONE</code> the system can only match
     * if the sub-types are exact matches. For example, only when the value of the Email field of Profile A and the
     * value of the Email field of Profile B matches, the two profiles are matched on the Email type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeMatchingModel} will return {@link AttributeMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeMatchingModelAsString}.
     * </p>
     * 
     * @return You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the AttributeMatchingModel.
     *         When choosing <code>MANY_TO_MANY</code>, the system can match attribute across the sub-types of an
     *         attribute type. For example, if the value of the Email field of Profile A and the value of BusinessEmail
     *         field of Profile B matches, the two profiles are matched on the Email type. When choosing
     *         <code>ONE_TO_ONE</code> the system can only match if the sub-types are exact matches. For example, only
     *         when the value of the Email field of Profile A and the value of the Email field of Profile B matches, the
     *         two profiles are matched on the Email type.
     * @see AttributeMatchingModel
     */
    public final AttributeMatchingModel attributeMatchingModel() {
        return AttributeMatchingModel.fromValue(attributeMatchingModel);
    }

    /**
     * <p>
     * You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the AttributeMatchingModel. When
     * choosing <code>MANY_TO_MANY</code>, the system can match attribute across the sub-types of an attribute type. For
     * example, if the value of the Email field of Profile A and the value of BusinessEmail field of Profile B matches,
     * the two profiles are matched on the Email type. When choosing <code>ONE_TO_ONE</code> the system can only match
     * if the sub-types are exact matches. For example, only when the value of the Email field of Profile A and the
     * value of the Email field of Profile B matches, the two profiles are matched on the Email type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeMatchingModel} will return {@link AttributeMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeMatchingModelAsString}.
     * </p>
     * 
     * @return You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the AttributeMatchingModel.
     *         When choosing <code>MANY_TO_MANY</code>, the system can match attribute across the sub-types of an
     *         attribute type. For example, if the value of the Email field of Profile A and the value of BusinessEmail
     *         field of Profile B matches, the two profiles are matched on the Email type. When choosing
     *         <code>ONE_TO_ONE</code> the system can only match if the sub-types are exact matches. For example, only
     *         when the value of the Email field of Profile A and the value of the Email field of Profile B matches, the
     *         two profiles are matched on the Email type.
     * @see AttributeMatchingModel
     */
    public final String attributeMatchingModelAsString() {
        return attributeMatchingModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Rule objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return A list of Rule objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code>.
     */
    public final List<Rule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeMatchingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleBasedProperties)) {
            return false;
        }
        RuleBasedProperties other = (RuleBasedProperties) obj;
        return Objects.equals(attributeMatchingModelAsString(), other.attributeMatchingModelAsString())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleBasedProperties").add("AttributeMatchingModel", attributeMatchingModelAsString())
                .add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeMatchingModel":
            return Optional.ofNullable(clazz.cast(attributeMatchingModelAsString()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleBasedProperties, T> g) {
        return obj -> g.apply((RuleBasedProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleBasedProperties> {
        /**
         * <p>
         * You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the AttributeMatchingModel.
         * When choosing <code>MANY_TO_MANY</code>, the system can match attribute across the sub-types of an attribute
         * type. For example, if the value of the Email field of Profile A and the value of BusinessEmail field of
         * Profile B matches, the two profiles are matched on the Email type. When choosing <code>ONE_TO_ONE</code> the
         * system can only match if the sub-types are exact matches. For example, only when the value of the Email field
         * of Profile A and the value of the Email field of Profile B matches, the two profiles are matched on the Email
         * type.
         * </p>
         * 
         * @param attributeMatchingModel
         *        You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         *        AttributeMatchingModel. When choosing <code>MANY_TO_MANY</code>, the system can match attribute across
         *        the sub-types of an attribute type. For example, if the value of the Email field of Profile A and the
         *        value of BusinessEmail field of Profile B matches, the two profiles are matched on the Email type.
         *        When choosing <code>ONE_TO_ONE</code> the system can only match if the sub-types are exact matches.
         *        For example, only when the value of the Email field of Profile A and the value of the Email field of
         *        Profile B matches, the two profiles are matched on the Email type.
         * @see AttributeMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeMatchingModel
         */
        Builder attributeMatchingModel(String attributeMatchingModel);

        /**
         * <p>
         * You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the AttributeMatchingModel.
         * When choosing <code>MANY_TO_MANY</code>, the system can match attribute across the sub-types of an attribute
         * type. For example, if the value of the Email field of Profile A and the value of BusinessEmail field of
         * Profile B matches, the two profiles are matched on the Email type. When choosing <code>ONE_TO_ONE</code> the
         * system can only match if the sub-types are exact matches. For example, only when the value of the Email field
         * of Profile A and the value of the Email field of Profile B matches, the two profiles are matched on the Email
         * type.
         * </p>
         * 
         * @param attributeMatchingModel
         *        You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         *        AttributeMatchingModel. When choosing <code>MANY_TO_MANY</code>, the system can match attribute across
         *        the sub-types of an attribute type. For example, if the value of the Email field of Profile A and the
         *        value of BusinessEmail field of Profile B matches, the two profiles are matched on the Email type.
         *        When choosing <code>ONE_TO_ONE</code> the system can only match if the sub-types are exact matches.
         *        For example, only when the value of the Email field of Profile A and the value of the Email field of
         *        Profile B matches, the two profiles are matched on the Email type.
         * @see AttributeMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeMatchingModel
         */
        Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel);

        /**
         * <p>
         * A list of Rule objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code>.
         * </p>
         * 
         * @param rules
         *        A list of Rule objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * A list of Rule objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code>.
         * </p>
         * 
         * @param rules
         *        A list of Rule objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * A list of Rule objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.Rule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.entityresolution.model.Rule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.Rule.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private String attributeMatchingModel;

        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleBasedProperties model) {
            attributeMatchingModel(model.attributeMatchingModel);
            rules(model.rules);
        }

        public final String getAttributeMatchingModel() {
            return attributeMatchingModel;
        }

        public final void setAttributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
        }

        @Override
        public final Builder attributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
            return this;
        }

        @Override
        public final Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel) {
            this.attributeMatchingModel(attributeMatchingModel == null ? null : attributeMatchingModel.toString());
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RuleBasedPropertiesRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleBasedPropertiesRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleBasedPropertiesRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RuleBasedProperties build() {
            return new RuleBasedProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
