/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing the <code>JobId</code>, <code>Status</code>, <code>StartTime</code>, and <code>EndTime</code> of
 * a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobSummary implements SdkPojo, Serializable, ToCopyableBuilder<JobSummary.Builder, JobSummary> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(JobSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(JobSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(JobSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(JobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, JOB_ID_FIELD,
            START_TIME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant endTime;

    private final String jobId;

    private final Instant startTime;

    private final String status;

    private JobSummary(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.jobId = builder.jobId;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time at which the job has finished.
     * </p>
     * 
     * @return The time at which the job has finished.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @return The ID of the job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The time at which the job was started.
     * </p>
     * 
     * @return The time at which the job was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The current status of the job. Either <code>running</code>, <code>succeeded</code>, <code>queued</code>, or
     * <code>failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the job. Either <code>running</code>, <code>succeeded</code>, <code>queued</code>,
     *         or <code>failed</code>.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the job. Either <code>running</code>, <code>succeeded</code>, <code>queued</code>, or
     * <code>failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the job. Either <code>running</code>, <code>succeeded</code>, <code>queued</code>,
     *         or <code>failed</code>.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobSummary").add("EndTime", endTime()).add("JobId", jobId()).add("StartTime", startTime())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobSummary, T> g) {
        return obj -> g.apply((JobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobSummary> {
        /**
         * <p>
         * The time at which the job has finished.
         * </p>
         * 
         * @param endTime
         *        The time at which the job has finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The ID of the job.
         * </p>
         * 
         * @param jobId
         *        The ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The time at which the job was started.
         * </p>
         * 
         * @param startTime
         *        The time at which the job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The current status of the job. Either <code>running</code>, <code>succeeded</code>, <code>queued</code>, or
         * <code>failed</code>.
         * </p>
         * 
         * @param status
         *        The current status of the job. Either <code>running</code>, <code>succeeded</code>,
         *        <code>queued</code>, or <code>failed</code>.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the job. Either <code>running</code>, <code>succeeded</code>, <code>queued</code>, or
         * <code>failed</code>.
         * </p>
         * 
         * @param status
         *        The current status of the job. Either <code>running</code>, <code>succeeded</code>,
         *        <code>queued</code>, or <code>failed</code>.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Instant endTime;

        private String jobId;

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            endTime(model.endTime);
            jobId(model.jobId);
            startTime(model.startTime);
            status(model.status);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public JobSummary build() {
            return new JobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
