/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchIdResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.StartMatchingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.TagResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.TagResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.UntagResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher;
import software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher;
import software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher;

/**
 * Service client for accessing AWSEntityResolution asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Welcome to the <i>AWS Entity Resolution API Reference</i>.
 * </p>
 * <p>
 * AWS Entity Resolution is an AWS service that provides pre-configured entity resolution capabilities that enable
 * developers and analysts at advertising and marketing companies to build an accurate and complete view of their
 * consumers.
 * </p>
 * <p>
 * With AWS Entity Resolution, you have the ability to match source records containing consumer identifiers, such as
 * name, email address, and phone number. This holds true even when these records have incomplete or conflicting
 * identifiers. For example, AWS Entity Resolution can effectively match a source record from a customer relationship
 * management (CRM) system, which includes account information like first name, last name, postal address, phone number,
 * and email address, with a source record from a marketing system containing campaign information, such as username and
 * email address.
 * </p>
 * <p>
 * To learn more about AWS Entity Resolution concepts, procedures, and best practices, see the <a
 * href="https://docs.aws.amazon.com/entityresolution/latest/userguide/what-is-service.html">AWS Entity Resolution User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EntityResolutionAsyncClient extends AwsClient {
    String SERVICE_NAME = "entityresolution";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "entityresolution";

    /**
     * <p>
     * Creates a <code>MatchingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. It is important to note that there should not be a pre-existing <code>MatchingWorkflow</code> with the same
     * name. To modify an existing workflow, utilize the <code>UpdateMatchingWorkflow</code> API.
     * </p>
     *
     * @param createMatchingWorkflowRequest
     * @return A Java Future containing the result of the CreateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current AWS Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMatchingWorkflowResponse> createMatchingWorkflow(
            CreateMatchingWorkflowRequest createMatchingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>MatchingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. It is important to note that there should not be a pre-existing <code>MatchingWorkflow</code> with the same
     * name. To modify an existing workflow, utilize the <code>UpdateMatchingWorkflow</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMatchingWorkflowRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMatchingWorkflowRequest#builder()}
     * </p>
     *
     * @param createMatchingWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link CreateMatchingWorkflowInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current AWS Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMatchingWorkflowResponse> createMatchingWorkflow(
            Consumer<CreateMatchingWorkflowRequest.Builder> createMatchingWorkflowRequest) {
        return createMatchingWorkflow(CreateMatchingWorkflowRequest.builder().applyMutation(createMatchingWorkflowRequest)
                .build());
    }

    /**
     * <p>
     * Creates a schema mapping, which defines the schema of the input customer records table. The
     * <code>SchemaMapping</code> also provides Entity Resolution with some metadata about the table, such as the
     * attribute types of the columns and which columns to match on.
     * </p>
     *
     * @param createSchemaMappingRequest
     * @return A Java Future containing the result of the CreateSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current AWS Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSchemaMappingResponse> createSchemaMapping(
            CreateSchemaMappingRequest createSchemaMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a schema mapping, which defines the schema of the input customer records table. The
     * <code>SchemaMapping</code> also provides Entity Resolution with some metadata about the table, such as the
     * attribute types of the columns and which columns to match on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSchemaMappingRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSchemaMappingRequest#builder()}
     * </p>
     *
     * @param createSchemaMappingRequest
     *        A {@link Consumer} that will call methods on {@link CreateSchemaMappingInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current AWS Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSchemaMappingResponse> createSchemaMapping(
            Consumer<CreateSchemaMappingRequest.Builder> createSchemaMappingRequest) {
        return createSchemaMapping(CreateSchemaMappingRequest.builder().applyMutation(createSchemaMappingRequest).build());
    }

    /**
     * <p>
     * Deletes the <code>MatchingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     *
     * @param deleteMatchingWorkflowRequest
     * @return A Java Future containing the result of the DeleteMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMatchingWorkflowResponse> deleteMatchingWorkflow(
            DeleteMatchingWorkflowRequest deleteMatchingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <code>MatchingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMatchingWorkflowRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMatchingWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteMatchingWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMatchingWorkflowInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMatchingWorkflowResponse> deleteMatchingWorkflow(
            Consumer<DeleteMatchingWorkflowRequest.Builder> deleteMatchingWorkflowRequest) {
        return deleteMatchingWorkflow(DeleteMatchingWorkflowRequest.builder().applyMutation(deleteMatchingWorkflowRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the <code>SchemaMapping</code> with a given name. This operation will succeed even if a schema with the
     * given name does not exist. This operation will fail if there is a <code>DataIntegrationWorkflow</code> object
     * that references the <code>SchemaMapping</code> in the workflow's <code>InputSourceConfig</code>.
     * </p>
     *
     * @param deleteSchemaMappingRequest
     * @return A Java Future containing the result of the DeleteSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSchemaMappingResponse> deleteSchemaMapping(
            DeleteSchemaMappingRequest deleteSchemaMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <code>SchemaMapping</code> with a given name. This operation will succeed even if a schema with the
     * given name does not exist. This operation will fail if there is a <code>DataIntegrationWorkflow</code> object
     * that references the <code>SchemaMapping</code> in the workflow's <code>InputSourceConfig</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaMappingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSchemaMappingRequest#builder()}
     * </p>
     *
     * @param deleteSchemaMappingRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSchemaMappingInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSchemaMappingResponse> deleteSchemaMapping(
            Consumer<DeleteSchemaMappingRequest.Builder> deleteSchemaMappingRequest) {
        return deleteSchemaMapping(DeleteSchemaMappingRequest.builder().applyMutation(deleteSchemaMappingRequest).build());
    }

    /**
     * <p>
     * Returns the corresponding Match ID of a customer record if the record has been processed.
     * </p>
     *
     * @param getMatchIdRequest
     * @return A Java Future containing the result of the GetMatchId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMatchIdResponse> getMatchId(GetMatchIdRequest getMatchIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the corresponding Match ID of a customer record if the record has been processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMatchIdRequest.Builder} avoiding the need to
     * create one manually via {@link GetMatchIdRequest#builder()}
     * </p>
     *
     * @param getMatchIdRequest
     *        A {@link Consumer} that will call methods on {@link GetMatchIdInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetMatchId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMatchIdResponse> getMatchId(Consumer<GetMatchIdRequest.Builder> getMatchIdRequest) {
        return getMatchId(GetMatchIdRequest.builder().applyMutation(getMatchIdRequest).build());
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     *
     * @param getMatchingJobRequest
     * @return A Java Future containing the result of the GetMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMatchingJobResponse> getMatchingJob(GetMatchingJobRequest getMatchingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMatchingJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetMatchingJobRequest#builder()}
     * </p>
     *
     * @param getMatchingJobRequest
     *        A {@link Consumer} that will call methods on {@link GetMatchingJobInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMatchingJobResponse> getMatchingJob(Consumer<GetMatchingJobRequest.Builder> getMatchingJobRequest) {
        return getMatchingJob(GetMatchingJobRequest.builder().applyMutation(getMatchingJobRequest).build());
    }

    /**
     * <p>
     * Returns the <code>MatchingWorkflow</code> with a given name, if it exists.
     * </p>
     *
     * @param getMatchingWorkflowRequest
     * @return A Java Future containing the result of the GetMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMatchingWorkflowResponse> getMatchingWorkflow(
            GetMatchingWorkflowRequest getMatchingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>MatchingWorkflow</code> with a given name, if it exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMatchingWorkflowRequest.Builder} avoiding the
     * need to create one manually via {@link GetMatchingWorkflowRequest#builder()}
     * </p>
     *
     * @param getMatchingWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link GetMatchingWorkflowInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMatchingWorkflowResponse> getMatchingWorkflow(
            Consumer<GetMatchingWorkflowRequest.Builder> getMatchingWorkflowRequest) {
        return getMatchingWorkflow(GetMatchingWorkflowRequest.builder().applyMutation(getMatchingWorkflowRequest).build());
    }

    /**
     * <p>
     * Returns the SchemaMapping of a given name.
     * </p>
     *
     * @param getSchemaMappingRequest
     * @return A Java Future containing the result of the GetSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaMappingResponse> getSchemaMapping(GetSchemaMappingRequest getSchemaMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the SchemaMapping of a given name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaMappingRequest.Builder} avoiding the need
     * to create one manually via {@link GetSchemaMappingRequest#builder()}
     * </p>
     *
     * @param getSchemaMappingRequest
     *        A {@link Consumer} that will call methods on {@link GetSchemaMappingInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaMappingResponse> getSchemaMapping(
            Consumer<GetSchemaMappingRequest.Builder> getSchemaMappingRequest) {
        return getSchemaMapping(GetSchemaMappingRequest.builder().applyMutation(getSchemaMappingRequest).build());
    }

    /**
     * <p>
     * Lists all jobs for a given workflow.
     * </p>
     *
     * @param listMatchingJobsRequest
     * @return A Java Future containing the result of the ListMatchingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMatchingJobsResponse> listMatchingJobs(ListMatchingJobsRequest listMatchingJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all jobs for a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMatchingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMatchingJobsRequest#builder()}
     * </p>
     *
     * @param listMatchingJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMatchingJobsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListMatchingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMatchingJobsResponse> listMatchingJobs(
            Consumer<ListMatchingJobsRequest.Builder> listMatchingJobsRequest) {
        return listMatchingJobs(ListMatchingJobsRequest.builder().applyMutation(listMatchingJobsRequest).build());
    }

    /**
     * <p>
     * Lists all jobs for a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMatchingJobs(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher publisher = client.listMatchingJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher publisher = client.listMatchingJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMatchingJobs(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMatchingJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMatchingJobsPublisher listMatchingJobsPaginator(ListMatchingJobsRequest listMatchingJobsRequest) {
        return new ListMatchingJobsPublisher(this, listMatchingJobsRequest);
    }

    /**
     * <p>
     * Lists all jobs for a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMatchingJobs(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher publisher = client.listMatchingJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher publisher = client.listMatchingJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMatchingJobs(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMatchingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMatchingJobsRequest#builder()}
     * </p>
     *
     * @param listMatchingJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMatchingJobsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMatchingJobsPublisher listMatchingJobsPaginator(Consumer<ListMatchingJobsRequest.Builder> listMatchingJobsRequest) {
        return listMatchingJobsPaginator(ListMatchingJobsRequest.builder().applyMutation(listMatchingJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the <code>MatchingWorkflows</code> that have been created for an AWS account.
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     * @return A Java Future containing the result of the ListMatchingWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMatchingWorkflowsResponse> listMatchingWorkflows(
            ListMatchingWorkflowsRequest listMatchingWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the <code>MatchingWorkflows</code> that have been created for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMatchingWorkflowsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMatchingWorkflowsRequest#builder()}
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListMatchingWorkflowsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMatchingWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMatchingWorkflowsResponse> listMatchingWorkflows(
            Consumer<ListMatchingWorkflowsRequest.Builder> listMatchingWorkflowsRequest) {
        return listMatchingWorkflows(ListMatchingWorkflowsRequest.builder().applyMutation(listMatchingWorkflowsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the <code>MatchingWorkflows</code> that have been created for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMatchingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher publisher = client.listMatchingWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher publisher = client.listMatchingWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMatchingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMatchingWorkflowsPublisher listMatchingWorkflowsPaginator(
            ListMatchingWorkflowsRequest listMatchingWorkflowsRequest) {
        return new ListMatchingWorkflowsPublisher(this, listMatchingWorkflowsRequest);
    }

    /**
     * <p>
     * Returns a list of all the <code>MatchingWorkflows</code> that have been created for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMatchingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher publisher = client.listMatchingWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher publisher = client.listMatchingWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMatchingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMatchingWorkflowsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMatchingWorkflowsRequest#builder()}
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListMatchingWorkflowsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMatchingWorkflowsPublisher listMatchingWorkflowsPaginator(
            Consumer<ListMatchingWorkflowsRequest.Builder> listMatchingWorkflowsRequest) {
        return listMatchingWorkflowsPaginator(ListMatchingWorkflowsRequest.builder().applyMutation(listMatchingWorkflowsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all the <code>SchemaMappings</code> that have been created for an AWS account.
     * </p>
     *
     * @param listSchemaMappingsRequest
     * @return A Java Future containing the result of the ListSchemaMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSchemaMappingsResponse> listSchemaMappings(ListSchemaMappingsRequest listSchemaMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the <code>SchemaMappings</code> that have been created for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaMappingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaMappingsRequest#builder()}
     * </p>
     *
     * @param listSchemaMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemaMappingsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListSchemaMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSchemaMappingsResponse> listSchemaMappings(
            Consumer<ListSchemaMappingsRequest.Builder> listSchemaMappingsRequest) {
        return listSchemaMappings(ListSchemaMappingsRequest.builder().applyMutation(listSchemaMappingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the <code>SchemaMappings</code> that have been created for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSchemaMappings(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher publisher = client.listSchemaMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher publisher = client.listSchemaMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaMappings(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSchemaMappingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaMappingsPublisher listSchemaMappingsPaginator(ListSchemaMappingsRequest listSchemaMappingsRequest) {
        return new ListSchemaMappingsPublisher(this, listSchemaMappingsRequest);
    }

    /**
     * <p>
     * Returns a list of all the <code>SchemaMappings</code> that have been created for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSchemaMappings(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher publisher = client.listSchemaMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher publisher = client.listSchemaMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaMappings(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaMappingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaMappingsRequest#builder()}
     * </p>
     *
     * @param listSchemaMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemaMappingsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaMappingsPublisher listSchemaMappingsPaginator(
            Consumer<ListSchemaMappingsRequest.Builder> listSchemaMappingsRequest) {
        return listSchemaMappingsPaginator(ListSchemaMappingsRequest.builder().applyMutation(listSchemaMappingsRequest).build());
    }

    /**
     * <p>
     * Displays the tags associated with an AWS Entity Resolution resource. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with an AWS Entity Resolution resource. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the <code>MatchingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateMatchingWorkflow</code> endpoint.
     * </p>
     *
     * @param startMatchingJobRequest
     * @return A Java Future containing the result of the StartMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current AWS Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.StartMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMatchingJobResponse> startMatchingJob(StartMatchingJobRequest startMatchingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the <code>MatchingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateMatchingWorkflow</code> endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMatchingJobRequest.Builder} avoiding the need
     * to create one manually via {@link StartMatchingJobRequest#builder()}
     * </p>
     *
     * @param startMatchingJobRequest
     *        A {@link Consumer} that will call methods on {@link StartMatchingJobInput.Builder} to create a request.
     * @return A Java Future containing the result of the StartMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current AWS Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.StartMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMatchingJobResponse> startMatchingJob(
            Consumer<StartMatchingJobRequest.Builder> startMatchingJobRequest) {
        return startMatchingJob(StartMatchingJobRequest.builder().applyMutation(startMatchingJobRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified AWS Entity Resolution resource. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions by granting a user
     * permission to access or change only resources with certain tag values. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged. Tags don't have any semantic meaning
     * to AWS and are interpreted strictly as strings of characters. You can use the <code>TagResource</code> action
     * with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags
     * associated with the resource. If you specify a tag key that is already associated with the resource, the new tag
     * value that you specify replaces the previous value for that tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified AWS Entity Resolution resource. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions by granting a user
     * permission to access or change only resources with certain tag values. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged. Tags don't have any semantic meaning
     * to AWS and are interpreted strictly as strings of characters. You can use the <code>TagResource</code> action
     * with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags
     * associated with the resource. If you specify a tag key that is already associated with the resource, the new tag
     * value that you specify replaces the previous value for that tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified AWS Entity Resolution resource. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified AWS Entity Resolution resource. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing <code>MatchingWorkflow</code>. This method is identical to
     * <code>CreateMatchingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>MatchingWorkflow</code> must already exist for the method to succeed.
     * </p>
     *
     * @param updateMatchingWorkflowRequest
     * @return A Java Future containing the result of the UpdateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMatchingWorkflowResponse> updateMatchingWorkflow(
            UpdateMatchingWorkflowRequest updateMatchingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <code>MatchingWorkflow</code>. This method is identical to
     * <code>CreateMatchingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>MatchingWorkflow</code> must already exist for the method to succeed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMatchingWorkflowRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMatchingWorkflowRequest#builder()}
     * </p>
     *
     * @param updateMatchingWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMatchingWorkflowInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the AWS Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by AWS Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMatchingWorkflowResponse> updateMatchingWorkflow(
            Consumer<UpdateMatchingWorkflowRequest.Builder> updateMatchingWorkflowRequest) {
        return updateMatchingWorkflow(UpdateMatchingWorkflowRequest.builder().applyMutation(updateMatchingWorkflowRequest)
                .build());
    }

    @Override
    default EntityResolutionServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link EntityResolutionAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EntityResolutionAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EntityResolutionAsyncClient}.
     */
    static EntityResolutionAsyncClientBuilder builder() {
        return new DefaultEntityResolutionAsyncClientBuilder();
    }
}
