/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.emr.DefaultEmrAsyncClient;
import software.amazon.awssdk.services.emr.DefaultEmrBaseClientBuilder;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.EmrAsyncClientBuilder;
import software.amazon.awssdk.services.emr.EmrServiceClientConfiguration;
import software.amazon.awssdk.services.emr.endpoints.EmrEndpointProvider;

@SdkInternalApi
final class DefaultEmrAsyncClientBuilder
extends DefaultEmrBaseClientBuilder<EmrAsyncClientBuilder, EmrAsyncClient>
implements EmrAsyncClientBuilder {
    DefaultEmrAsyncClientBuilder() {
    }

    @Override
    public DefaultEmrAsyncClientBuilder endpointProvider(EmrEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EmrAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEmrAsyncClientBuilder.validateClientOptions(clientConfiguration);
        EmrServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEmrAsyncClient client = new DefaultEmrAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EmrServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EmrServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

