/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Managed scaling policy for an Amazon EMR cluster. The policy specifies the limits for resources that can be added or
 * terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after
 * initial configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedScalingPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedScalingPolicy.Builder, ManagedScalingPolicy> {
    private static final SdkField<ComputeLimits> COMPUTE_LIMITS_FIELD = SdkField
            .<ComputeLimits> builder(MarshallingType.SDK_POJO).memberName("ComputeLimits")
            .getter(getter(ManagedScalingPolicy::computeLimits)).setter(setter(Builder::computeLimits))
            .constructor(ComputeLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeLimits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_LIMITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ComputeLimits computeLimits;

    private ManagedScalingPolicy(BuilderImpl builder) {
        this.computeLimits = builder.computeLimits;
    }

    /**
     * <p>
     * The Amazon EC2 unit limits for a managed scaling policy. The managed scaling activity of a cluster is not allowed
     * to go above or below these limits. The limit only applies to the core and task nodes. The master node cannot be
     * scaled after initial configuration.
     * </p>
     * 
     * @return The Amazon EC2 unit limits for a managed scaling policy. The managed scaling activity of a cluster is not
     *         allowed to go above or below these limits. The limit only applies to the core and task nodes. The master
     *         node cannot be scaled after initial configuration.
     */
    public final ComputeLimits computeLimits() {
        return computeLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeLimits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedScalingPolicy)) {
            return false;
        }
        ManagedScalingPolicy other = (ManagedScalingPolicy) obj;
        return Objects.equals(computeLimits(), other.computeLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedScalingPolicy").add("ComputeLimits", computeLimits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputeLimits":
            return Optional.ofNullable(clazz.cast(computeLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedScalingPolicy, T> g) {
        return obj -> g.apply((ManagedScalingPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedScalingPolicy> {
        /**
         * <p>
         * The Amazon EC2 unit limits for a managed scaling policy. The managed scaling activity of a cluster is not
         * allowed to go above or below these limits. The limit only applies to the core and task nodes. The master node
         * cannot be scaled after initial configuration.
         * </p>
         * 
         * @param computeLimits
         *        The Amazon EC2 unit limits for a managed scaling policy. The managed scaling activity of a cluster is
         *        not allowed to go above or below these limits. The limit only applies to the core and task nodes. The
         *        master node cannot be scaled after initial configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeLimits(ComputeLimits computeLimits);

        /**
         * <p>
         * The Amazon EC2 unit limits for a managed scaling policy. The managed scaling activity of a cluster is not
         * allowed to go above or below these limits. The limit only applies to the core and task nodes. The master node
         * cannot be scaled after initial configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeLimits.Builder} avoiding the need
         * to create one manually via {@link ComputeLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #computeLimits(ComputeLimits)}.
         * 
         * @param computeLimits
         *        a consumer that will call methods on {@link ComputeLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeLimits(ComputeLimits)
         */
        default Builder computeLimits(Consumer<ComputeLimits.Builder> computeLimits) {
            return computeLimits(ComputeLimits.builder().applyMutation(computeLimits).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ComputeLimits computeLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedScalingPolicy model) {
            computeLimits(model.computeLimits);
        }

        public final ComputeLimits.Builder getComputeLimits() {
            return computeLimits != null ? computeLimits.toBuilder() : null;
        }

        public final void setComputeLimits(ComputeLimits.BuilderImpl computeLimits) {
            this.computeLimits = computeLimits != null ? computeLimits.build() : null;
        }

        @Override
        public final Builder computeLimits(ComputeLimits computeLimits) {
            this.computeLimits = computeLimits;
            return this;
        }

        @Override
        public ManagedScalingPolicy build() {
            return new ManagedScalingPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
