/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A job flow step consisting of a JAR file whose main function will be executed. The main function submits a job for
 * Hadoop to execute and waits for the job to finish or fail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HadoopJarStepConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HadoopJarStepConfig.Builder, HadoopJarStepConfig> {
    private static final SdkField<List<KeyValue>> PROPERTIES_FIELD = SdkField
            .<List<KeyValue>> builder(MarshallingType.LIST)
            .memberName("Properties")
            .getter(getter(HadoopJarStepConfig::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JAR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Jar")
            .getter(getter(HadoopJarStepConfig::jar)).setter(setter(Builder::jar))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jar").build()).build();

    private static final SdkField<String> MAIN_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MainClass").getter(getter(HadoopJarStepConfig::mainClass)).setter(setter(Builder::mainClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MainClass").build()).build();

    private static final SdkField<List<String>> ARGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Args")
            .getter(getter(HadoopJarStepConfig::args))
            .setter(setter(Builder::args))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTIES_FIELD, JAR_FIELD,
            MAIN_CLASS_FIELD, ARGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<KeyValue> properties;

    private final String jar;

    private final String mainClass;

    private final List<String> args;

    private HadoopJarStepConfig(BuilderImpl builder) {
        this.properties = builder.properties;
        this.jar = builder.jar;
        this.mainClass = builder.mainClass;
        this.args = builder.args;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Java properties that are set when the step runs. You can use these properties to pass key-value pairs
     * to your main function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return A list of Java properties that are set when the step runs. You can use these properties to pass key-value
     *         pairs to your main function.
     */
    public final List<KeyValue> properties() {
        return properties;
    }

    /**
     * <p>
     * A path to a JAR file run during the step.
     * </p>
     * 
     * @return A path to a JAR file run during the step.
     */
    public final String jar() {
        return jar;
    }

    /**
     * <p>
     * The name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class
     * in its manifest file.
     * </p>
     * 
     * @return The name of the main class in the specified Java file. If not specified, the JAR file should specify a
     *         Main-Class in its manifest file.
     */
    public final String mainClass() {
        return mainClass;
    }

    /**
     * For responses, this returns true if the service returned a value for the Args property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasArgs() {
        return args != null && !(args instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of command line arguments passed to the JAR file's main function when executed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArgs} method.
     * </p>
     * 
     * @return A list of command line arguments passed to the JAR file's main function when executed.
     */
    public final List<String> args() {
        return args;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jar());
        hashCode = 31 * hashCode + Objects.hashCode(mainClass());
        hashCode = 31 * hashCode + Objects.hashCode(hasArgs() ? args() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HadoopJarStepConfig)) {
            return false;
        }
        HadoopJarStepConfig other = (HadoopJarStepConfig) obj;
        return hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && Objects.equals(jar(), other.jar()) && Objects.equals(mainClass(), other.mainClass())
                && hasArgs() == other.hasArgs() && Objects.equals(args(), other.args());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HadoopJarStepConfig").add("Properties", hasProperties() ? properties() : null).add("Jar", jar())
                .add("MainClass", mainClass()).add("Args", hasArgs() ? args() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "Jar":
            return Optional.ofNullable(clazz.cast(jar()));
        case "MainClass":
            return Optional.ofNullable(clazz.cast(mainClass()));
        case "Args":
            return Optional.ofNullable(clazz.cast(args()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HadoopJarStepConfig, T> g) {
        return obj -> g.apply((HadoopJarStepConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HadoopJarStepConfig> {
        /**
         * <p>
         * A list of Java properties that are set when the step runs. You can use these properties to pass key-value
         * pairs to your main function.
         * </p>
         * 
         * @param properties
         *        A list of Java properties that are set when the step runs. You can use these properties to pass
         *        key-value pairs to your main function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<KeyValue> properties);

        /**
         * <p>
         * A list of Java properties that are set when the step runs. You can use these properties to pass key-value
         * pairs to your main function.
         * </p>
         * 
         * @param properties
         *        A list of Java properties that are set when the step runs. You can use these properties to pass
         *        key-value pairs to your main function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(KeyValue... properties);

        /**
         * <p>
         * A list of Java properties that are set when the step runs. You can use these properties to pass key-value
         * pairs to your main function.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.KeyValue.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.emr.model.KeyValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.KeyValue.Builder#build()} is called immediately and its
         * result is passed to {@link #properties(List<KeyValue>)}.
         * 
         * @param properties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.KeyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(java.util.Collection<KeyValue>)
         */
        Builder properties(Consumer<KeyValue.Builder>... properties);

        /**
         * <p>
         * A path to a JAR file run during the step.
         * </p>
         * 
         * @param jar
         *        A path to a JAR file run during the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jar(String jar);

        /**
         * <p>
         * The name of the main class in the specified Java file. If not specified, the JAR file should specify a
         * Main-Class in its manifest file.
         * </p>
         * 
         * @param mainClass
         *        The name of the main class in the specified Java file. If not specified, the JAR file should specify a
         *        Main-Class in its manifest file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mainClass(String mainClass);

        /**
         * <p>
         * A list of command line arguments passed to the JAR file's main function when executed.
         * </p>
         * 
         * @param args
         *        A list of command line arguments passed to the JAR file's main function when executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder args(Collection<String> args);

        /**
         * <p>
         * A list of command line arguments passed to the JAR file's main function when executed.
         * </p>
         * 
         * @param args
         *        A list of command line arguments passed to the JAR file's main function when executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder args(String... args);
    }

    static final class BuilderImpl implements Builder {
        private List<KeyValue> properties = DefaultSdkAutoConstructList.getInstance();

        private String jar;

        private String mainClass;

        private List<String> args = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HadoopJarStepConfig model) {
            properties(model.properties);
            jar(model.jar);
            mainClass(model.mainClass);
            args(model.args);
        }

        public final List<KeyValue.Builder> getProperties() {
            List<KeyValue.Builder> result = KeyValueListCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<KeyValue.BuilderImpl> properties) {
            this.properties = KeyValueListCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<KeyValue> properties) {
            this.properties = KeyValueListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(KeyValue... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<KeyValue.Builder>... properties) {
            properties(Stream.of(properties).map(c -> KeyValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getJar() {
            return jar;
        }

        public final void setJar(String jar) {
            this.jar = jar;
        }

        @Override
        public final Builder jar(String jar) {
            this.jar = jar;
            return this;
        }

        public final String getMainClass() {
            return mainClass;
        }

        public final void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        @Override
        public final Builder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public final Collection<String> getArgs() {
            if (args instanceof SdkAutoConstructList) {
                return null;
            }
            return args;
        }

        public final void setArgs(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String... args) {
            args(Arrays.asList(args));
            return this;
        }

        @Override
        public HadoopJarStepConfig build() {
            return new HadoopJarStepConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
