/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsByPipelineRequest
extends ElasticTranscoderRequest
implements ToCopyableBuilder<Builder, ListJobsByPipelineRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineId").getter(ListJobsByPipelineRequest.getter(ListJobsByPipelineRequest::pipelineId)).setter(ListJobsByPipelineRequest.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PipelineId").build()}).build();
    private static final SdkField<String> ASCENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ascending").getter(ListJobsByPipelineRequest.getter(ListJobsByPipelineRequest::ascending)).setter(ListJobsByPipelineRequest.setter(Builder::ascending)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Ascending").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageToken").getter(ListJobsByPipelineRequest.getter(ListJobsByPipelineRequest::pageToken)).setter(ListJobsByPipelineRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD, ASCENDING_FIELD, PAGE_TOKEN_FIELD));
    private final String pipelineId;
    private final String ascending;
    private final String pageToken;

    private ListJobsByPipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.ascending = builder.ascending;
        this.pageToken = builder.pageToken;
    }

    public final String pipelineId() {
        return this.pipelineId;
    }

    public final String ascending() {
        return this.ascending;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ascending());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsByPipelineRequest)) {
            return false;
        }
        ListJobsByPipelineRequest other = (ListJobsByPipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.ascending(), other.ascending()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobsByPipelineRequest").add("PipelineId", (Object)this.pipelineId()).add("Ascending", (Object)this.ascending()).add("PageToken", (Object)this.pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "Ascending": {
                return Optional.ofNullable(clazz.cast(this.ascending()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsByPipelineRequest, T> g) {
        return obj -> g.apply((ListJobsByPipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private String ascending;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsByPipelineRequest model) {
            super(model);
            this.pipelineId(model.pipelineId);
            this.ascending(model.ascending);
            this.pageToken(model.pageToken);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final String getAscending() {
            return this.ascending;
        }

        public final void setAscending(String ascending) {
            this.ascending = ascending;
        }

        @Override
        public final Builder ascending(String ascending) {
            this.ascending = ascending;
            return this;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsByPipelineRequest build() {
            return new ListJobsByPipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticTranscoderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobsByPipelineRequest> {
        public Builder pipelineId(String var1);

        public Builder ascending(String var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

