/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse;

public class DescribeInboundCrossClusterSearchConnectionsPublisher
implements SdkPublisher<DescribeInboundCrossClusterSearchConnectionsResponse> {
    private final ElasticsearchAsyncClient client;
    private final DescribeInboundCrossClusterSearchConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInboundCrossClusterSearchConnectionsPublisher(ElasticsearchAsyncClient client, DescribeInboundCrossClusterSearchConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInboundCrossClusterSearchConnectionsPublisher(ElasticsearchAsyncClient client, DescribeInboundCrossClusterSearchConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInboundCrossClusterSearchConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInboundCrossClusterSearchConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeInboundCrossClusterSearchConnectionsResponseFetcher
    implements AsyncPageFetcher<DescribeInboundCrossClusterSearchConnectionsResponse> {
        private DescribeInboundCrossClusterSearchConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInboundCrossClusterSearchConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInboundCrossClusterSearchConnectionsResponse> nextPage(DescribeInboundCrossClusterSearchConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInboundCrossClusterSearchConnectionsPublisher.this.client.describeInboundCrossClusterSearchConnections(DescribeInboundCrossClusterSearchConnectionsPublisher.this.firstRequest);
            }
            return DescribeInboundCrossClusterSearchConnectionsPublisher.this.client.describeInboundCrossClusterSearchConnections((DescribeInboundCrossClusterSearchConnectionsRequest)((Object)DescribeInboundCrossClusterSearchConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

