/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TimeUnit {
    HOURS("HOURS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TimeUnit> VALUE_MAP;
    private final String value;

    private TimeUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimeUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TimeUnit> knownValues() {
        EnumSet<TimeUnit> knownValues = EnumSet.allOf(TimeUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TimeUnit.class, TimeUnit::toString);
    }
}

