/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticinference.DefaultElasticInferenceBaseClientBuilder;
import software.amazon.awssdk.services.elasticinference.DefaultElasticInferenceClient;
import software.amazon.awssdk.services.elasticinference.ElasticInferenceClient;
import software.amazon.awssdk.services.elasticinference.ElasticInferenceClientBuilder;
import software.amazon.awssdk.services.elasticinference.ElasticInferenceServiceClientConfiguration;
import software.amazon.awssdk.services.elasticinference.endpoints.ElasticInferenceEndpointProvider;

@SdkInternalApi
final class DefaultElasticInferenceClientBuilder
extends DefaultElasticInferenceBaseClientBuilder<ElasticInferenceClientBuilder, ElasticInferenceClient>
implements ElasticInferenceClientBuilder {
    DefaultElasticInferenceClientBuilder() {
    }

    @Override
    public DefaultElasticInferenceClientBuilder endpointProvider(ElasticInferenceEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticInferenceClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultElasticInferenceClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ElasticInferenceServiceClientConfiguration serviceClientConfiguration = ElasticInferenceServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultElasticInferenceClient(serviceClientConfiguration, clientConfiguration);
    }
}

