/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceRepository {
    CODE_COMMIT("CodeCommit"),
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceRepository> VALUE_MAP;
    private final String value;

    private SourceRepository(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceRepository fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceRepository> knownValues() {
        EnumSet<SourceRepository> knownValues = EnumSet.allOf(SourceRepository.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceRepository.class, SourceRepository::toString);
    }
}

