/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlatformBranchesResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ListPlatformBranchesResponse> {
    private static final SdkField<List<PlatformBranchSummary>> PLATFORM_BRANCH_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlatformBranchSummaryList").getter(ListPlatformBranchesResponse.getter(ListPlatformBranchesResponse::platformBranchSummaryList)).setter(ListPlatformBranchesResponse.setter(Builder::platformBranchSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlatformBranchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPlatformBranchesResponse.getter(ListPlatformBranchesResponse::nextToken)).setter(ListPlatformBranchesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_BRANCH_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<PlatformBranchSummary> platformBranchSummaryList;
    private final String nextToken;

    private ListPlatformBranchesResponse(BuilderImpl builder) {
        super(builder);
        this.platformBranchSummaryList = builder.platformBranchSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPlatformBranchSummaryList() {
        return this.platformBranchSummaryList != null && !(this.platformBranchSummaryList instanceof SdkAutoConstructList);
    }

    public final List<PlatformBranchSummary> platformBranchSummaryList() {
        return this.platformBranchSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformBranchSummaryList() ? this.platformBranchSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformBranchesResponse)) {
            return false;
        }
        ListPlatformBranchesResponse other = (ListPlatformBranchesResponse)((Object)obj);
        return this.hasPlatformBranchSummaryList() == other.hasPlatformBranchSummaryList() && Objects.equals(this.platformBranchSummaryList(), other.platformBranchSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPlatformBranchesResponse").add("PlatformBranchSummaryList", this.hasPlatformBranchSummaryList() ? this.platformBranchSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformBranchSummaryList": {
                return Optional.ofNullable(clazz.cast(this.platformBranchSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlatformBranchesResponse, T> g) {
        return obj -> g.apply((ListPlatformBranchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<PlatformBranchSummary> platformBranchSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformBranchesResponse model) {
            super(model);
            this.platformBranchSummaryList(model.platformBranchSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<PlatformBranchSummary.Builder> getPlatformBranchSummaryList() {
            if (this.platformBranchSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platformBranchSummaryList != null ? (Collection)this.platformBranchSummaryList.stream().map(PlatformBranchSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platformBranchSummaryList(Collection<PlatformBranchSummary> platformBranchSummaryList) {
            this.platformBranchSummaryList = PlatformBranchSummaryListCopier.copy(platformBranchSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformBranchSummaryList(PlatformBranchSummary ... platformBranchSummaryList) {
            this.platformBranchSummaryList(Arrays.asList(platformBranchSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformBranchSummaryList(Consumer<PlatformBranchSummary.Builder> ... platformBranchSummaryList) {
            this.platformBranchSummaryList(Stream.of(platformBranchSummaryList).map(c -> (PlatformBranchSummary)((PlatformBranchSummary.Builder)PlatformBranchSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlatformBranchSummaryList(Collection<PlatformBranchSummary.BuilderImpl> platformBranchSummaryList) {
            this.platformBranchSummaryList = PlatformBranchSummaryListCopier.copyFromBuilder(platformBranchSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPlatformBranchesResponse build() {
            return new ListPlatformBranchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPlatformBranchesResponse> {
        public Builder platformBranchSummaryList(Collection<PlatformBranchSummary> var1);

        public Builder platformBranchSummaryList(PlatformBranchSummary ... var1);

        public Builder platformBranchSummaryList(Consumer<PlatformBranchSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

