/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.waiters.ElastiCacheWaiter;
import software.amazon.awssdk.services.elasticache.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultElastiCacheWaiter
implements ElastiCacheWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final ElastiCacheClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeCacheClustersResponse> cacheClusterAvailableWaiter;
    private final Waiter<DescribeCacheClustersResponse> cacheClusterDeletedWaiter;
    private final Waiter<DescribeReplicationGroupsResponse> replicationGroupAvailableWaiter;
    private final Waiter<DescribeReplicationGroupsResponse> replicationGroupDeletedWaiter;

    private DefaultElastiCacheWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ElastiCacheClient)ElastiCacheClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.cacheClusterAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeCacheClustersResponse.class).acceptors(DefaultElastiCacheWaiter.cacheClusterAvailableWaiterAcceptors())).overrideConfiguration(DefaultElastiCacheWaiter.cacheClusterAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.cacheClusterDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeCacheClustersResponse.class).acceptors(DefaultElastiCacheWaiter.cacheClusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultElastiCacheWaiter.cacheClusterDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.replicationGroupAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeReplicationGroupsResponse.class).acceptors(DefaultElastiCacheWaiter.replicationGroupAvailableWaiterAcceptors())).overrideConfiguration(DefaultElastiCacheWaiter.replicationGroupAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.replicationGroupDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeReplicationGroupsResponse.class).acceptors(DefaultElastiCacheWaiter.replicationGroupDeletedWaiterAcceptors())).overrideConfiguration(DefaultElastiCacheWaiter.replicationGroupDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeCacheClustersResponse> waitUntilCacheClusterAvailable(DescribeCacheClustersRequest describeCacheClustersRequest) {
        return this.cacheClusterAvailableWaiter.run(() -> this.client.describeCacheClusters(this.applyWaitersUserAgent(describeCacheClustersRequest)));
    }

    @Override
    public WaiterResponse<DescribeCacheClustersResponse> waitUntilCacheClusterAvailable(DescribeCacheClustersRequest describeCacheClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.cacheClusterAvailableWaiter.run(() -> this.client.describeCacheClusters(this.applyWaitersUserAgent(describeCacheClustersRequest)), DefaultElastiCacheWaiter.cacheClusterAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeCacheClustersResponse> waitUntilCacheClusterDeleted(DescribeCacheClustersRequest describeCacheClustersRequest) {
        return this.cacheClusterDeletedWaiter.run(() -> this.client.describeCacheClusters(this.applyWaitersUserAgent(describeCacheClustersRequest)));
    }

    @Override
    public WaiterResponse<DescribeCacheClustersResponse> waitUntilCacheClusterDeleted(DescribeCacheClustersRequest describeCacheClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.cacheClusterDeletedWaiter.run(() -> this.client.describeCacheClusters(this.applyWaitersUserAgent(describeCacheClustersRequest)), DefaultElastiCacheWaiter.cacheClusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeReplicationGroupsResponse> waitUntilReplicationGroupAvailable(DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        return this.replicationGroupAvailableWaiter.run(() -> this.client.describeReplicationGroups(this.applyWaitersUserAgent(describeReplicationGroupsRequest)));
    }

    @Override
    public WaiterResponse<DescribeReplicationGroupsResponse> waitUntilReplicationGroupAvailable(DescribeReplicationGroupsRequest describeReplicationGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationGroupAvailableWaiter.run(() -> this.client.describeReplicationGroups(this.applyWaitersUserAgent(describeReplicationGroupsRequest)), DefaultElastiCacheWaiter.replicationGroupAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeReplicationGroupsResponse> waitUntilReplicationGroupDeleted(DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        return this.replicationGroupDeletedWaiter.run(() -> this.client.describeReplicationGroups(this.applyWaitersUserAgent(describeReplicationGroupsRequest)));
    }

    @Override
    public WaiterResponse<DescribeReplicationGroupsResponse> waitUntilReplicationGroupDeleted(DescribeReplicationGroupsRequest describeReplicationGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationGroupDeletedWaiter.run(() -> this.client.describeReplicationGroups(this.applyWaitersUserAgent(describeReplicationGroupsRequest)), DefaultElastiCacheWaiter.replicationGroupDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeCacheClustersResponse>> cacheClusterAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCacheClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCacheClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-network"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "restore-failed"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeCacheClustersResponse>> cacheClusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCacheClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCacheClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultElastiCacheWaiter.errorCode(error), "CacheClusterNotFound")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-network"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "restore-failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("CacheClusters").flatten().field("CacheClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "snapshotting"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationGroupsResponse>> replicationGroupAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationGroups").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationGroups").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationGroupsResponse>> replicationGroupDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationGroups").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationGroups").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultElastiCacheWaiter.errorCode(error), "ReplicationGroupNotFoundFault")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration cacheClusterAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration cacheClusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationGroupAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationGroupDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ElastiCacheWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ElastiCacheRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElastiCacheRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ElastiCacheWaiter.Builder {
        private ElastiCacheClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public ElastiCacheWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ElastiCacheWaiter.Builder client(ElastiCacheClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ElastiCacheWaiter build() {
            return new DefaultElastiCacheWaiter(this);
        }
    }
}

