/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceUpdateType {
    SECURITY_UPDATE("security-update"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceUpdateType> VALUE_MAP;
    private final String value;

    private ServiceUpdateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceUpdateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceUpdateType> knownValues() {
        EnumSet<ServiceUpdateType> knownValues = EnumSet.allOf(ServiceUpdateType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceUpdateType.class, ServiceUpdateType::toString);
    }
}

