/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkType {
    IPV4("ipv4"),
    IPV6("ipv6"),
    DUAL_STACK("dual_stack"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkType> VALUE_MAP;
    private final String value;

    private NetworkType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkType> knownValues() {
        EnumSet<NetworkType> knownValues = EnumSet.allOf(NetworkType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkType.class, NetworkType::toString);
    }
}

