/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup;
import software.amazon.awssdk.services.elasticache.model.GlobalNodeGroupListCopier;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMemberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalReplicationGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalReplicationGroup> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalReplicationGroupId").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::globalReplicationGroupId)).setter(GlobalReplicationGroup.setter(Builder::globalReplicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build()}).build();
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalReplicationGroupDescription").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::globalReplicationGroupDescription)).setter(GlobalReplicationGroup.setter(Builder::globalReplicationGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupDescription").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::status)).setter(GlobalReplicationGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeType").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::cacheNodeType)).setter(GlobalReplicationGroup.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::engine)).setter(GlobalReplicationGroup.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::engineVersion)).setter(GlobalReplicationGroup.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<List<GlobalReplicationGroupMember>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Members").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::members)).setter(GlobalReplicationGroup.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName("GlobalReplicationGroupMember").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalReplicationGroupMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupMember").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CLUSTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ClusterEnabled").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::clusterEnabled)).setter(GlobalReplicationGroup.setter(Builder::clusterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEnabled").build()}).build();
    private static final SdkField<List<GlobalNodeGroup>> GLOBAL_NODE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalNodeGroups").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::globalNodeGroups)).setter(GlobalReplicationGroup.setter(Builder::globalNodeGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNodeGroups").build(), ListTrait.builder().memberLocationName("GlobalNodeGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalNodeGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNodeGroup").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTH_TOKEN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AuthTokenEnabled").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::authTokenEnabled)).setter(GlobalReplicationGroup.setter(Builder::authTokenEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenEnabled").build()}).build();
    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TransitEncryptionEnabled").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::transitEncryptionEnabled)).setter(GlobalReplicationGroup.setter(Builder::transitEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AtRestEncryptionEnabled").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::atRestEncryptionEnabled)).setter(GlobalReplicationGroup.setter(Builder::atRestEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(GlobalReplicationGroup.getter(GlobalReplicationGroup::arn)).setter(GlobalReplicationGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_REPLICATION_GROUP_ID_FIELD, GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD, STATUS_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, MEMBERS_FIELD, CLUSTER_ENABLED_FIELD, GLOBAL_NODE_GROUPS_FIELD, AUTH_TOKEN_ENABLED_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String globalReplicationGroupId;
    private final String globalReplicationGroupDescription;
    private final String status;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final List<GlobalReplicationGroupMember> members;
    private final Boolean clusterEnabled;
    private final List<GlobalNodeGroup> globalNodeGroups;
    private final Boolean authTokenEnabled;
    private final Boolean transitEncryptionEnabled;
    private final Boolean atRestEncryptionEnabled;
    private final String arn;

    private GlobalReplicationGroup(BuilderImpl builder) {
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.globalReplicationGroupDescription = builder.globalReplicationGroupDescription;
        this.status = builder.status;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.members = builder.members;
        this.clusterEnabled = builder.clusterEnabled;
        this.globalNodeGroups = builder.globalNodeGroups;
        this.authTokenEnabled = builder.authTokenEnabled;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.arn = builder.arn;
    }

    public final String globalReplicationGroupId() {
        return this.globalReplicationGroupId;
    }

    public final String globalReplicationGroupDescription() {
        return this.globalReplicationGroupDescription;
    }

    public final String status() {
        return this.status;
    }

    public final String cacheNodeType() {
        return this.cacheNodeType;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<GlobalReplicationGroupMember> members() {
        return this.members;
    }

    public final Boolean clusterEnabled() {
        return this.clusterEnabled;
    }

    public final boolean hasGlobalNodeGroups() {
        return this.globalNodeGroups != null && !(this.globalNodeGroups instanceof SdkAutoConstructList);
    }

    public final List<GlobalNodeGroup> globalNodeGroups() {
        return this.globalNodeGroups;
    }

    public final Boolean authTokenEnabled() {
        return this.authTokenEnabled;
    }

    public final Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public final Boolean atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalNodeGroups() ? this.globalNodeGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalReplicationGroup)) {
            return false;
        }
        GlobalReplicationGroup other = (GlobalReplicationGroup)obj;
        return Objects.equals(this.globalReplicationGroupId(), other.globalReplicationGroupId()) && Objects.equals(this.globalReplicationGroupDescription(), other.globalReplicationGroupDescription()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members()) && Objects.equals(this.clusterEnabled(), other.clusterEnabled()) && this.hasGlobalNodeGroups() == other.hasGlobalNodeGroups() && Objects.equals(this.globalNodeGroups(), other.globalNodeGroups()) && Objects.equals(this.authTokenEnabled(), other.authTokenEnabled()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.atRestEncryptionEnabled(), other.atRestEncryptionEnabled()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalReplicationGroup").add("GlobalReplicationGroupId", (Object)this.globalReplicationGroupId()).add("GlobalReplicationGroupDescription", (Object)this.globalReplicationGroupDescription()).add("Status", (Object)this.status()).add("CacheNodeType", (Object)this.cacheNodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("Members", this.hasMembers() ? this.members() : null).add("ClusterEnabled", (Object)this.clusterEnabled()).add("GlobalNodeGroups", this.hasGlobalNodeGroups() ? this.globalNodeGroups() : null).add("AuthTokenEnabled", (Object)this.authTokenEnabled()).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("AtRestEncryptionEnabled", (Object)this.atRestEncryptionEnabled()).add("ARN", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroupId()));
            }
            case "GlobalReplicationGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroupDescription()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "ClusterEnabled": {
                return Optional.ofNullable(clazz.cast(this.clusterEnabled()));
            }
            case "GlobalNodeGroups": {
                return Optional.ofNullable(clazz.cast(this.globalNodeGroups()));
            }
            case "AuthTokenEnabled": {
                return Optional.ofNullable(clazz.cast(this.authTokenEnabled()));
            }
            case "TransitEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "AtRestEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.atRestEncryptionEnabled()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalReplicationGroup, T> g) {
        return obj -> g.apply((GlobalReplicationGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String globalReplicationGroupId;
        private String globalReplicationGroupDescription;
        private String status;
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private List<GlobalReplicationGroupMember> members = DefaultSdkAutoConstructList.getInstance();
        private Boolean clusterEnabled;
        private List<GlobalNodeGroup> globalNodeGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean authTokenEnabled;
        private Boolean transitEncryptionEnabled;
        private Boolean atRestEncryptionEnabled;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalReplicationGroup model) {
            this.globalReplicationGroupId(model.globalReplicationGroupId);
            this.globalReplicationGroupDescription(model.globalReplicationGroupDescription);
            this.status(model.status);
            this.cacheNodeType(model.cacheNodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.members(model.members);
            this.clusterEnabled(model.clusterEnabled);
            this.globalNodeGroups(model.globalNodeGroups);
            this.authTokenEnabled(model.authTokenEnabled);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            this.arn(model.arn);
        }

        public final String getGlobalReplicationGroupId() {
            return this.globalReplicationGroupId;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final String getGlobalReplicationGroupDescription() {
            return this.globalReplicationGroupDescription;
        }

        public final void setGlobalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
        }

        @Override
        public final Builder globalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final List<GlobalReplicationGroupMember.Builder> getMembers() {
            List<GlobalReplicationGroupMember.Builder> result = GlobalReplicationGroupMemberListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<GlobalReplicationGroupMember.BuilderImpl> members) {
            this.members = GlobalReplicationGroupMemberListCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<GlobalReplicationGroupMember> members) {
            this.members = GlobalReplicationGroupMemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(GlobalReplicationGroupMember ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<GlobalReplicationGroupMember.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (GlobalReplicationGroupMember)((GlobalReplicationGroupMember.Builder)GlobalReplicationGroupMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getClusterEnabled() {
            return this.clusterEnabled;
        }

        public final void setClusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
        }

        @Override
        public final Builder clusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
            return this;
        }

        public final List<GlobalNodeGroup.Builder> getGlobalNodeGroups() {
            List<GlobalNodeGroup.Builder> result = GlobalNodeGroupListCopier.copyToBuilder(this.globalNodeGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalNodeGroups(Collection<GlobalNodeGroup.BuilderImpl> globalNodeGroups) {
            this.globalNodeGroups = GlobalNodeGroupListCopier.copyFromBuilder(globalNodeGroups);
        }

        @Override
        public final Builder globalNodeGroups(Collection<GlobalNodeGroup> globalNodeGroups) {
            this.globalNodeGroups = GlobalNodeGroupListCopier.copy(globalNodeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNodeGroups(GlobalNodeGroup ... globalNodeGroups) {
            this.globalNodeGroups(Arrays.asList(globalNodeGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNodeGroups(Consumer<GlobalNodeGroup.Builder> ... globalNodeGroups) {
            this.globalNodeGroups(Stream.of(globalNodeGroups).map(c -> (GlobalNodeGroup)((GlobalNodeGroup.Builder)GlobalNodeGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAuthTokenEnabled() {
            return this.authTokenEnabled;
        }

        public final void setAuthTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
        }

        @Override
        public final Builder authTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public GlobalReplicationGroup build() {
            return new GlobalReplicationGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalReplicationGroup> {
        public Builder globalReplicationGroupId(String var1);

        public Builder globalReplicationGroupDescription(String var1);

        public Builder status(String var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder members(Collection<GlobalReplicationGroupMember> var1);

        public Builder members(GlobalReplicationGroupMember ... var1);

        public Builder members(Consumer<GlobalReplicationGroupMember.Builder> ... var1);

        public Builder clusterEnabled(Boolean var1);

        public Builder globalNodeGroups(Collection<GlobalNodeGroup> var1);

        public Builder globalNodeGroups(GlobalNodeGroup ... var1);

        public Builder globalNodeGroups(Consumer<GlobalNodeGroup.Builder> ... var1);

        public Builder authTokenEnabled(Boolean var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder atRestEncryptionEnabled(Boolean var1);

        public Builder arn(String var1);
    }
}

