/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum UpdateParamType {
    VERSION("Version"),

    PLATFORM_VERSION("PlatformVersion"),

    ENDPOINT_PRIVATE_ACCESS("EndpointPrivateAccess"),

    ENDPOINT_PUBLIC_ACCESS("EndpointPublicAccess"),

    CLUSTER_LOGGING("ClusterLogging"),

    DESIRED_SIZE("DesiredSize"),

    LABELS_TO_ADD("LabelsToAdd"),

    LABELS_TO_REMOVE("LabelsToRemove"),

    TAINTS_TO_ADD("TaintsToAdd"),

    TAINTS_TO_REMOVE("TaintsToRemove"),

    MAX_SIZE("MaxSize"),

    MIN_SIZE("MinSize"),

    RELEASE_VERSION("ReleaseVersion"),

    PUBLIC_ACCESS_CIDRS("PublicAccessCidrs"),

    LAUNCH_TEMPLATE_NAME("LaunchTemplateName"),

    LAUNCH_TEMPLATE_VERSION("LaunchTemplateVersion"),

    IDENTITY_PROVIDER_CONFIG("IdentityProviderConfig"),

    ENCRYPTION_CONFIG("EncryptionConfig"),

    ADDON_VERSION("AddonVersion"),

    SERVICE_ACCOUNT_ROLE_ARN("ServiceAccountRoleArn"),

    RESOLVE_CONFLICTS("ResolveConflicts"),

    MAX_UNAVAILABLE("MaxUnavailable"),

    MAX_UNAVAILABLE_PERCENTAGE("MaxUnavailablePercentage"),

    CONFIGURATION_VALUES("ConfigurationValues"),

    SECURITY_GROUPS("SecurityGroups"),

    SUBNETS("Subnets"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateParamType> VALUE_MAP = EnumUtils.uniqueIndex(UpdateParamType.class,
            UpdateParamType::toString);

    private final String value;

    private UpdateParamType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return UpdateParamType corresponding to the value
     */
    public static UpdateParamType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link UpdateParamType}s
     */
    public static Set<UpdateParamType> knownValues() {
        Set<UpdateParamType> knownValues = EnumSet.allOf(UpdateParamType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
