/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * These errors are usually caused by a server-side issue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerException extends EksException implements ToCopyableBuilder<ServerException.Builder, ServerException> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(ServerException::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodegroupName").getter(getter(ServerException::nodegroupName)).setter(setter(Builder::nodegroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroupName").build()).build();

    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonName").getter(getter(ServerException::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODEGROUP_NAME_FIELD, ADDON_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterName;

    private final String nodegroupName;

    private final String addonName;

    private ServerException(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.addonName = builder.addonName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The Amazon EKS cluster associated with the exception.
     * </p>
     * 
     * @return The Amazon EKS cluster associated with the exception.
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The Amazon EKS managed node group associated with the exception.
     * </p>
     * 
     * @return The Amazon EKS managed node group associated with the exception.
     */
    public String nodegroupName() {
        return nodegroupName;
    }

    /**
     * Returns the value of the AddonName property for this object.
     * 
     * @return The value of the AddonName property for this object.
     */
    public String addonName() {
        return addonName;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerException, T> g) {
        return obj -> g.apply((ServerException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerException>, EksException.Builder {
        /**
         * <p>
         * The Amazon EKS cluster associated with the exception.
         * </p>
         * 
         * @param clusterName
         *        The Amazon EKS cluster associated with the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The Amazon EKS managed node group associated with the exception.
         * </p>
         * 
         * @param nodegroupName
         *        The Amazon EKS managed node group associated with the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupName(String nodegroupName);

        /**
         * Sets the value of the AddonName property for this object.
         *
         * @param addonName
         *        The new value for the AddonName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends EksException.BuilderImpl implements Builder {
        private String clusterName;

        private String nodegroupName;

        private String addonName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerException model) {
            super(model);
            clusterName(model.clusterName);
            nodegroupName(model.nodegroupName);
            addonName(model.addonName);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNodegroupName() {
            return nodegroupName;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ServerException build() {
            return new ServerException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
