/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.efs.EfsClient;
import software.amazon.awssdk.services.efs.internal.UserAgentUtils;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse;

public class DescribeAccessPointsIterable
implements SdkIterable<DescribeAccessPointsResponse> {
    private final EfsClient client;
    private final DescribeAccessPointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAccessPointsIterable(EfsClient client, DescribeAccessPointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAccessPointsResponseFetcher();
    }

    public Iterator<DescribeAccessPointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeAccessPointsResponseFetcher
    implements SyncPageFetcher<DescribeAccessPointsResponse> {
        private DescribeAccessPointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAccessPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAccessPointsResponse nextPage(DescribeAccessPointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAccessPointsIterable.this.client.describeAccessPoints(DescribeAccessPointsIterable.this.firstRequest);
            }
            return DescribeAccessPointsIterable.this.client.describeAccessPoints((DescribeAccessPointsRequest)((Object)DescribeAccessPointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

